/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/path=journal-directory")
@ResourceType(value="path")
@Implicit
public class JournalDirectoryPath<T extends JournalDirectoryPath<T>>
implements Keyed {
    private String key = "journal-directory";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The actual filesystem path. Treated as an absolute path, unless the 'relative-to' attribute is specified, in which case the value is treated as relative to that path. If treated as an absolute path, the actual runtime pathname specified by the value of this attribute will be determined as follows: If this value is already absolute, then the value is directly used.  Otherwise the runtime pathname is resolved in a system-dependent way.  On UNIX systems, a relative pathname is made absolute by resolving it against the current user directory. On Microsoft Windows systems, a relative pathname is made absolute by resolving it against the current directory of the drive named by the pathname, if any; if not, it is resolved against the current user directory.")
    private String path;
    @AttributeDocumentation(value="The name of another previously named path, or of one of the standard paths provided by the system. If 'relative-to' is provided, the value of the 'path' attribute is treated as relative to the path specified by this attribute. The standard paths provided by the system include: jboss.home - the root directory of the JBoss AS distribution, user.home - user's home directory, user.dir - user's current working directory, java.home - java installation directory, jboss.server.base.dir - root directory for an individual server instance, jboss.server.data.dir - directory the server will use for persistent data file storage, jboss.server.log.dir - directory the server will use for log file storage, jboss.server.tmp.dir - directory the server will use for temporary file storage, and jboss.domain.servers.dir - directory under which a host controller will create the working area for individual server instances.")
    private String relativeTo;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="path")
    public String path() {
        return this.path;
    }

    public T path(String value) {
        String oldValue = this.path;
        this.path = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("path", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="relative-to")
    public String relativeTo() {
        return this.relativeTo;
    }

    public T relativeTo(String value) {
        String oldValue = this.relativeTo;
        this.relativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("relativeTo", oldValue, value);
        }
        return (T)this;
    }
}

