/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=security/elytron-realm=*")
@ResourceType(value="elytron-realm")
public class ElytronRealm<T extends ElytronRealm<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Indicates to the realm if it should apply the role mappers defined in the legacy domain to the roles obtained from authenticated Subjects or not.")
    private Boolean applyRoleMappers;
    @AttributeDocumentation(value="The name of the legacy security domain to which authentication will be delegated.")
    private String legacyJaasConfig;

    public ElytronRealm(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="apply-role-mappers")
    public Boolean applyRoleMappers() {
        return this.applyRoleMappers;
    }

    public T applyRoleMappers(Boolean value) {
        Boolean oldValue = this.applyRoleMappers;
        this.applyRoleMappers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("applyRoleMappers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="legacy-jaas-config")
    public String legacyJaasConfig() {
        return this.legacyJaasConfig;
    }

    public T legacyJaasConfig(String value) {
        String oldValue = this.legacyJaasConfig;
        this.legacyJaasConfig = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("legacyJaasConfig", oldValue, value);
        }
        return (T)this;
    }
}

