/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.container.internal.ProjectStageImpl;
import org.wildfly.swarm.spi.api.ProjectStage;
import org.yaml.snakeyaml.Yaml;

public class ProjectStageFactory {
    private static final String PROJECT_PREFIX = "project";
    private static final String STAGE = "stage";
    private static final String DEFAULT = "default";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProjectStage> loadStages(InputStream inputStream) {
        try {
            LinkedList<ProjectStage> stages = new LinkedList<ProjectStage>();
            Yaml yaml = new Yaml();
            Iterable docs = yaml.loadAll(inputStream);
            for (Object item : docs) {
                Map doc = (Map)item;
                String stageName = doc.get(PROJECT_PREFIX) != null ? (String)((Map)doc.get(PROJECT_PREFIX)).get(STAGE) : DEFAULT;
                ProjectStageImpl stage = new ProjectStageImpl(stageName);
                for (String key : doc.keySet()) {
                    if (key.equals(PROJECT_PREFIX)) continue;
                    stage.getConfig().put(key, doc.get(key));
                }
                stages.add(stage.initialize());
            }
            LinkedList<ProjectStage> linkedList = stages;
            return linkedList;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

