/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cli;

import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import org.wildfly.swarm.cli.CommandLine;
import org.wildfly.swarm.cli.ParseState;

public class Option<T> {
    private static final int MAX_LINE_LENGTH = 50;
    private Character shortArg;
    private String longArg;
    private String valueDescription;
    private boolean valueMayBeSeparate = true;
    private Action<T> action;
    private String description;
    private Supplier<T> supplier;

    public Option<T> then(Action<T> action) {
        this.action = action;
        return this;
    }

    public void displayHelp(PrintStream out) {
        out.println(this.merge(this.summary(), this.description()));
    }

    private List<String> summary() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.shortArg != null) {
            if (this.hasValue()) {
                if (this.valueDescription.contains("=")) {
                    list.add("-" + this.shortArg + this.valueDescription);
                } else {
                    list.add("-" + this.shortArg + "=" + this.valueDescription);
                }
                if (this.valueMayBeSeparate) {
                    if (this.valueDescription.contains("=")) {
                        list.add("-" + this.shortArg + this.valueDescription.replace('=', ' '));
                    } else {
                        list.add("-" + this.shortArg + " " + this.valueDescription);
                    }
                }
            } else {
                list.add("-" + this.shortArg);
            }
        }
        if (this.longArg != null) {
            if (this.hasValue()) {
                if (this.valueDescription.contains("=")) {
                    list.add("--" + this.longArg + this.valueDescription);
                } else {
                    list.add("--" + this.longArg + "=" + this.valueDescription);
                }
                if (this.valueMayBeSeparate) {
                    if (this.valueDescription.contains("=")) {
                        list.add("--" + this.longArg + this.valueDescription.replace('=', ' '));
                    } else {
                        list.add("--" + this.longArg + " " + this.valueDescription);
                    }
                }
            } else {
                list.add("--" + this.longArg);
            }
        }
        return list;
    }

    private List<String> description() {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.description);
        StringBuilder line = new StringBuilder();
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            if (line.length() + (" " + token).length() > 50) {
                list.add(line.toString());
                line = new StringBuilder();
            }
            if (line.length() != 0) {
                line.append(" ");
            }
            line.append(token);
        }
        list.add(line.toString());
        return list;
    }

    private String merge(List<String> summary, List<String> desc) {
        int i;
        int diff;
        if (summary.size() > desc.size()) {
            diff = summary.size() - desc.size();
            for (i = 0; i < diff; ++i) {
                desc.add("");
            }
        }
        if (desc.size() > summary.size()) {
            diff = desc.size() - summary.size();
            for (i = 0; i < diff; ++i) {
                summary.add("");
            }
        }
        StringBuilder txt = new StringBuilder();
        for (i = 0; i < summary.size(); ++i) {
            txt.append(String.format("  %-30s     %s", summary.get(i), desc.get(i)));
            txt.append("\n");
        }
        return txt.toString();
    }

    public Option<T> withShort(Character shortArg) {
        this.shortArg = shortArg;
        return this;
    }

    public Option<T> withLong(String longArg) {
        this.longArg = longArg;
        return this;
    }

    public Option<T> withDescription(String description) {
        this.description = description;
        return this;
    }

    public Option<T> hasValue(String valueDescription) {
        this.valueDescription = valueDescription;
        return this;
    }

    private boolean hasValue() {
        return this.valueDescription != null;
    }

    public Option<T> valueMayBeSeparate(boolean valueMayBeSeparate) {
        this.valueMayBeSeparate = valueMayBeSeparate;
        return this;
    }

    public Option<T> withDefault(Supplier<T> supplier) {
        this.supplier = supplier;
        return this;
    }

    T defaultValue() {
        if (this.supplier == null) {
            return null;
        }
        return this.supplier.get();
    }

    boolean parse(ParseState state, CommandLine commandLine) throws Exception {
        String cur = state.la();
        if (cur == null) {
            return false;
        }
        String value = null;
        String matchedArg = null;
        if (this.shortArg != null && cur.startsWith("-" + this.shortArg)) {
            matchedArg = "-" + this.shortArg;
            if (this.hasValue() && cur.length() >= 3) {
                value = cur.charAt(2) == '=' ? cur.substring(3) : cur.substring(2);
            }
        } else if (this.longArg != null && cur.startsWith("--" + this.longArg)) {
            matchedArg = "--" + this.longArg;
            if (this.hasValue() && cur.length() >= this.longArg.length() + 3) {
                value = cur.charAt(this.longArg.length() + 3) == '=' ? cur.substring(this.longArg.length() + 3) : cur.substring(this.longArg.length() + 2);
            }
        } else {
            return false;
        }
        state.consume();
        if (value != null && value.trim().isEmpty()) {
            value = null;
        }
        if (this.hasValue() && value == null && !this.valueMayBeSeparate) {
            throw new RuntimeException(matchedArg + " requires an argument");
        }
        if (this.hasValue() && value == null) {
            if (state.la() == null) {
                throw new RuntimeException(matchedArg + " requires an argument");
            }
            value = state.consume();
        }
        this.action.set(commandLine, this, value);
        return true;
    }

    public String toString() {
        return "[Option: short=" + this.shortArg + "; long=" + this.longArg + "; valueDescription=" + this.valueDescription + "]";
    }

    public static URL toURL(String value) throws MalformedURLException {
        try {
            URL url = new URL(value);
            return url;
        }
        catch (MalformedURLException e) {
            try {
                return new File(value).toURI().toURL();
            }
            catch (MalformedURLException e2) {
                throw e;
            }
        }
    }

    public static interface Action<T> {
        public void set(CommandLine var1, Option<T> var2, String var3) throws Exception;
    }
}

