/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.cli.CommandLine;
import org.wildfly.swarm.cli.Option;
import org.wildfly.swarm.cli.ParseState;

public class Options {
    private final List<Option> options = new ArrayList<Option>();

    public Options(Option ... options) {
        for (Option option : options) {
            this.options.add(option);
        }
    }

    public Options withOption(Option option) {
        this.options.add(option);
        return this;
    }

    public void displayHelp(PrintStream out) {
        for (Option option : this.options) {
            option.displayHelp(out);
        }
    }

    void parse(ParseState state, CommandLine commandLine) throws Exception {
        block0: while (state.la() != null) {
            for (Option option : this.options) {
                if (!option.parse(state, commandLine)) continue;
                continue block0;
            }
            String arg = state.consume();
            if (arg.startsWith("-")) {
                commandLine.invalidArgument(arg);
            }
            commandLine.extraArgument(arg);
        }
    }
}

