/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.spi.api.ProjectStage;

public class ProjectStageImpl
implements ProjectStage {
    private String name;
    private Map<String, Object> config = new HashMap<String, Object>();
    private Map<String, String> properties = new HashMap<String, String>();

    public ProjectStageImpl(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    ProjectStage initialize() {
        for (String key : this.config.keySet()) {
            String[] lines;
            StringBuffer buffer = new StringBuffer();
            this.parse(buffer, null, key, this.config);
            for (String line : lines = buffer.toString().split("\n")) {
                int pos = line.indexOf(61);
                String left = line.substring(0, pos);
                if (null == System.getProperty(left)) {
                    this.properties.put(left, line.substring(pos + 1, line.length()));
                    continue;
                }
                this.properties.put(left, System.getProperty(left));
            }
        }
        return this;
    }

    Map<String, Object> getConfig() {
        return this.config;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    private void parse(StringBuffer buffer, String parent, String key, Map<String, Object> config) {
        if (parent != null && buffer.substring(buffer.length() - 1, buffer.length()).equals("\n")) {
            buffer.append(parent);
        }
        buffer.append(key);
        Object o = config.get(key);
        if (o instanceof Map) {
            buffer.append(".");
            Map child = (Map)o;
            String nextParent = buffer.toString();
            for (String childKey : child.keySet()) {
                this.parse(buffer, nextParent, childKey, child);
            }
        } else if (o instanceof List) {
            List list = (List)o;
            int i = 0;
            String prefix = buffer.toString();
            for (Object item : list) {
                if (i == 0) {
                    buffer.append("[").append(i).append("]");
                } else {
                    buffer.append(prefix).append("[").append(i).append("]");
                }
                buffer.append("=").append(item);
                buffer.append("\n");
                ++i;
            }
        } else {
            buffer.append("=").append(o);
            buffer.append("\n");
        }
    }

    public String toString() {
        return "ProjectStage{name='" + this.name + '\'' + ", config=" + this.config + '}';
    }
}

