/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmClasspathConf;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmDependenciesConf;
import org.wildfly.swarm.spi.api.ArtifactLookup;

public class ArtifactManager
implements ArtifactLookup {
    private final WildFlySwarmDependenciesConf deps;

    public ArtifactManager(WildFlySwarmDependenciesConf deps) {
        this.deps = deps;
    }

    public ArtifactManager(InputStream in) throws IOException {
        this.deps = new WildFlySwarmDependenciesConf(in);
    }

    public ArtifactManager() throws IOException {
        InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("META-INF/wildfly-swarm-dependencies.conf");
        this.deps = in != null ? new WildFlySwarmDependenciesConf(in) : null;
    }

    public JavaArchive artifact(String gav) throws IOException, ModuleLoadException {
        return this.artifact(gav, null);
    }

    public JavaArchive artifact(String gav, String asName) throws IOException, ModuleLoadException {
        File file = this.findFile(gav);
        if (file == null) {
            throw new RuntimeException("Artifact '" + gav + "' not found.");
        }
        return (JavaArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)(asName == null ? file.getName() : asName))).importFrom(file)).as(JavaArchive.class);
    }

    public List<JavaArchive> allArtifacts() throws IOException {
        return this.allArtifacts("");
    }

    public List<JavaArchive> allArtifacts(String ... groupIdExclusions) throws IOException {
        HashMap<String, Assignable> archives;
        block22: {
            List<String> exclusions;
            block21: {
                archives = new HashMap<String, Assignable>();
                exclusions = Arrays.asList(groupIdExclusions);
                if (this.deps == null) break block21;
                for (MavenArtifactDescriptor each : this.deps.getPrimaryDependencies()) {
                    if (exclusions.contains(each.groupId())) continue;
                    File artifact = MavenResolvers.get().resolveJarArtifact(each.mscCoordinates());
                    archives.put(artifact.getName(), ((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)artifact.getName())).importFrom(artifact)).as(JavaArchive.class));
                }
                break block22;
            }
            String classpath = System.getProperty("java.class.path");
            String javaHome = System.getProperty("java.home");
            String pwd = System.getProperty("user.dir");
            String testClasspath = System.getProperty("swarm.test.dependencies");
            exclusions.replaceAll(s -> s.replace('.', File.separatorChar));
            if (classpath == null) break block22;
            WildFlySwarmClasspathConf classpathConf = new WildFlySwarmClasspathConf();
            HashSet<String> classpathElements = new HashSet<String>();
            HashSet<String> providedGAVs = new HashSet<String>();
            List<Object> testClasspathElements = testClasspath != null && testClasspath.trim().length() > 0 ? Arrays.asList(testClasspath.split(File.pathSeparator)) : new ArrayList();
            for (String element : classpath.split(File.pathSeparator)) {
                if (element.startsWith(javaHome) || element.startsWith(pwd + File.separatorChar) || element.endsWith(".pom")) continue;
                try (JarFile jar = new JarFile(new File(element));){
                    ZipEntry entry = jar.getEntry("META-INF/wildfly-swarm-classpath.conf");
                    if (entry != null) {
                        classpathConf.read(jar.getInputStream(entry));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.excluded(exclusions, element)) continue;
                classpathElements.add(element);
            }
            providedGAVs.addAll(classpathConf.getMatchesForActionType(WildFlySwarmClasspathConf.MavenMatcher.class, WildFlySwarmClasspathConf.RemoveAction.class).stream().map(m -> (WildFlySwarmClasspathConf.MavenMatcher)m).map(m -> m.groupId + "." + m.artifactId).map(m -> m.replace('.', File.separatorChar)).collect(Collectors.toList()));
            for (String element : classpathElements) {
                if (this.excluded(providedGAVs, element) || this.excluded(testClasspathElements, element)) continue;
                File artifact = new File(element);
                if (artifact.isFile()) {
                    archives.put(artifact.getName(), ((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)artifact.getName())).importFrom(artifact)).as(JavaArchive.class));
                    continue;
                }
                String archiveName = this.archiveNameForClassesDir(artifact.toPath());
                if (archives.containsKey(archiveName)) {
                    ((ExplodedImporter)((JavaArchive)archives.get(archiveName)).as(ExplodedImporter.class)).importDirectory(artifact);
                    continue;
                }
                archives.put(archiveName, ((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)archiveName)).importDirectory(artifact).as(JavaArchive.class));
            }
        }
        return new ArrayList<JavaArchive>(archives.values());
    }

    String archiveNameForClassesDir(Path element) {
        if (element.endsWith("target/classes")) {
            return element.subpath(element.getNameCount() - 3, element.getNameCount() - 2).toString() + ".jar";
        }
        if (element.endsWith("build/classes/main") || element.endsWith("build/resources/main")) {
            return element.subpath(element.getNameCount() - 4, element.getNameCount() - 3).toString() + ".jar";
        }
        return UUID.randomUUID().toString() + ".jar";
    }

    private boolean excluded(Collection<String> exclusions, String classPathElement) {
        for (String exclusion : exclusions) {
            if (!classPathElement.contains(exclusion)) continue;
            return true;
        }
        return false;
    }

    private File findFile(String gav) throws IOException, ModuleLoadException {
        String[] parts = gav.split(":");
        if (parts.length < 2) {
            throw new RuntimeException("GAV must includes at least 2 segments");
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String packaging = "jar";
        String version = null;
        String classifier = "";
        if (parts.length == 3) {
            version = parts[2];
        }
        if (parts.length == 4) {
            packaging = parts[2];
            version = parts[3];
        }
        if (parts.length == 5) {
            packaging = parts[2];
            version = parts[3];
            classifier = parts[4];
        }
        if (version != null && (version.isEmpty() || version.equals("*"))) {
            version = null;
        }
        if (version == null) {
            version = this.determineVersionViaDependenciesConf(groupId, artifactId, packaging, classifier);
        }
        if (version == null) {
            version = this.determineVersionViaClasspath(groupId, artifactId, packaging, classifier);
        }
        if (version == null) {
            throw new RuntimeException("Unable to determine version number from GAV: " + gav);
        }
        return MavenResolvers.get().resolveArtifact(new ArtifactCoordinates(groupId, artifactId, version, classifier == null ? "" : classifier), packaging);
    }

    String determineVersionViaDependenciesConf(String groupId, String artifactId, String packaging, String classifier) throws IOException {
        MavenArtifactDescriptor found;
        if (this.deps != null && (found = this.deps.find(groupId, artifactId, packaging, classifier)) != null) {
            return found.version();
        }
        return null;
    }

    private String determineVersionViaClasspath(String groupId, String artifactId, String packaging, String classifier) {
        String regexp = ".*" + artifactId + "-(.+)" + (classifier.length() == 0 ? "" : "-" + classifier) + "." + packaging;
        Pattern pattern = Pattern.compile(regexp);
        for (String element : System.getProperty("java.class.path").split(File.pathSeparator)) {
            Matcher matcher = pattern.matcher(element);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

