/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.Swarm;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.runtime.ServerConfiguration;

public abstract class AbstractServerConfiguration<T extends Fraction>
implements ServerConfiguration<T> {
    private final Class<T> type;
    private List<DeploymentSpec> deployments = new ArrayList<DeploymentSpec>();

    public AbstractServerConfiguration(Class<T> type) {
        this.type = type;
    }

    protected DeploymentSpec deployment(String gav) {
        DeploymentSpec spec = new DeploymentSpec(gav);
        this.deployments.add(spec);
        return spec;
    }

    @Override
    public List<Archive> getImplicitDeployments(T fraction) throws Exception {
        if (this.deployments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (DeploymentSpec deployment : this.deployments) {
            archives.add(deployment.toArchive(fraction));
        }
        return archives;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T defaultFraction() {
        try {
            return (T)((Fraction)this.getType().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public class DeploymentSpec {
        private final String gav;
        private String asName;
        private BiConsumer<T, Archive<?>> config;

        public DeploymentSpec(String gav) {
            this.gav = gav;
        }

        public DeploymentSpec as(String asName) {
            this.asName = asName;
            return this;
        }

        public DeploymentSpec configure(BiConsumer<T, Archive<?>> config) {
            this.config = config;
            return this;
        }

        Archive<?> toArchive(T fraction) throws Exception {
            JavaArchive archive = this.asName == null ? Swarm.artifact((String)this.gav) : Swarm.artifact((String)this.gav, (String)this.asName);
            if (this.config != null) {
                this.config.accept(fraction, (Archive<?>)archive);
            }
            return archive;
        }
    }
}

