/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.util.BootstrapProperties;
import org.wildfly.swarm.container.Deployer;
import org.wildfly.swarm.container.DeploymentException;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.runtime.ServerConfiguration;
import org.wildfly.swarm.container.runtime.SimpleContentProvider;

public class RuntimeDeployer
implements Deployer {
    private final ModelControllerClient client;
    private final SimpleContentProvider contentProvider;
    private final List<ServerConfiguration<Fraction>> configurations;
    private final TempFileProvider tempFileProvider;
    private final List<Closeable> mountPoints = new ArrayList<Closeable>();
    private boolean debug = false;

    public RuntimeDeployer(List<ServerConfiguration<Fraction>> configurations, ModelControllerClient client, SimpleContentProvider contentProvider, TempFileProvider tempFileProvider) throws IOException {
        this.configurations = configurations;
        this.client = client;
        this.contentProvider = contentProvider;
        this.tempFileProvider = tempFileProvider;
    }

    public void debug(boolean debug) {
        this.debug = debug;
    }

    public void deploy(Archive<?> deployment) throws DeploymentException {
        for (ServerConfiguration<Fraction> serverConfiguration : this.configurations) {
            serverConfiguration.prepareArchive(deployment);
        }
        if (this.debug) {
            Map c = deployment.getContent();
            for (Map.Entry entry : c.entrySet()) {
                System.err.println(entry.getKey() + " // " + entry.getValue());
            }
        }
        if (BootstrapProperties.flagIsSet((String)"swarm.export.deployment")) {
            File out = new File(deployment.getName());
            System.err.println("Exporting deployment to " + out.getAbsolutePath());
            ((ZipExporter)deployment.as(ZipExporter.class)).exportTo(out, true);
        }
        VirtualFile mountPoint = VFS.getRootVirtualFile().getChild(deployment.getName());
        try {
            Throwable throwable = null;
            try (InputStream inputStream = ((ZipExporter)deployment.as(ZipExporter.class)).exportAsInputStream();){
                Closeable closeable = VFS.mountZipExpanded((InputStream)inputStream, (String)deployment.getName(), (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
                this.mountPoints.add(closeable);
            }
            catch (Throwable closeable) {
                Throwable throwable2 = closeable;
                throw closeable;
            }
        }
        catch (IOException iOException) {
            throw new DeploymentException(deployment, (Throwable)iOException);
        }
        byte[] byArray = this.contentProvider.addContent(mountPoint);
        ModelNode modelNode = new ModelNode();
        modelNode.get("operation").set("add");
        modelNode.get("address").set("deployment", deployment.getName());
        modelNode.get("runtime-name").set(deployment.getName());
        modelNode.get("enabled").set(true);
        int deploymentTimeout = Integer.parseInt(System.getProperty("swarm.deployment.timeout", "300"));
        ModelNode opHeaders = new ModelNode();
        opHeaders.get("blocking-timeout").set(deploymentTimeout);
        modelNode.get("operation-headers").set(opHeaders);
        ModelNode content = modelNode.get("content").add();
        content.get("hash").set(byArray);
        BootstrapLogger.logger((String)"org.wildfly.swarm.runtime.deployer").info((Object)("deploying " + deployment.getName()));
        System.setProperty("swarm.current.deployment", deployment.getName());
        try {
            ModelNode result = this.client.execute(modelNode);
            ModelNode outcome = result.get("outcome");
            if (outcome.asString().equals("success")) {
                return;
            }
            ModelNode description = result.get("failure-description");
            throw new DeploymentException(deployment, description.asString());
        }
        catch (IOException e) {
            throw new DeploymentException(deployment, (Throwable)e);
        }
    }

    void stop() {
        for (Closeable each : this.mountPoints) {
            try {
                each.close();
            }
            catch (IOException iOException) {}
        }
    }
}

