/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.selfcontained.ContentProvider;
import org.jboss.as.server.SelfContainedContainer;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.vfs.TempFileProvider;
import org.wildfly.swarm.SwarmProperties;
import org.wildfly.swarm.bootstrap.logging.BackingLoggerManager;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.container.OutboundSocketBinding;
import org.wildfly.swarm.container.SocketBinding;
import org.wildfly.swarm.container.SocketBindingGroup;
import org.wildfly.swarm.container.internal.Deployer;
import org.wildfly.swarm.container.internal.Server;
import org.wildfly.swarm.container.runtime.JBossLoggingManager;
import org.wildfly.swarm.container.runtime.LoggingConfigurator;
import org.wildfly.swarm.container.runtime.RuntimeDeployer;
import org.wildfly.swarm.container.runtime.ServerConfiguration;
import org.wildfly.swarm.container.runtime.SimpleContentProvider;
import org.wildfly.swarm.container.runtime.StandaloneXmlParser;
import org.wildfly.swarm.container.runtime.UUIDFactory;

public class RuntimeServer
implements Server {
    private SelfContainedContainer container = new SelfContainedContainer();
    private SimpleContentProvider contentProvider = new SimpleContentProvider();
    private ServiceContainer serviceContainer;
    private ModelControllerClient client;
    private RuntimeDeployer deployer;
    private Map<Class<? extends Fraction>, ServerConfiguration> configByFractionType = new ConcurrentHashMap<Class<? extends Fraction>, ServerConfiguration>();
    private List<ServerConfiguration<Fraction>> configList = new ArrayList<ServerConfiguration<Fraction>>();
    private Optional<URL> xmlConfig = Optional.empty();
    private BootstrapLogger LOG = BootstrapLogger.logger((String)"org.wildfly.swarm.runtime.server");
    private boolean debug;

    public RuntimeServer() {
        try {
            Module loggingModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.logging", (String)"runtime"));
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)loggingModule.getClassLoader());
                System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
                System.setProperty("org.jboss.logmanager.configurator", LoggingConfigurator.class.getName());
                LogManager.getLogManager();
                BootstrapLogger.setBackingLoggerManager((BackingLoggerManager)new JBossLoggingManager());
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
        catch (ModuleLoadException e) {
            System.err.println("[WARN] logging not available, logging will not be configured");
        }
    }

    public void setXmlConfig(URL xmlConfig) {
        if (null == xmlConfig) {
            throw new IllegalArgumentException("Invalid XML config");
        }
        this.xmlConfig = Optional.of(xmlConfig);
    }

    public void debug(boolean debug) {
        this.debug = debug;
    }

    public Deployer start(Container config) throws Exception {
        UUID uuid = UUIDFactory.getUUID();
        System.setProperty("jboss.server.management.uuid", uuid.toString());
        this.loadFractionConfigurations();
        this.applyDefaults(config);
        for (Fraction fraction : config.fractions()) {
            fraction.postInitialize(config.createPostInitContext());
        }
        if (!this.xmlConfig.isPresent()) {
            this.applySocketBindingGroupDefaults(config);
        }
        LinkedList<ModelNode> bootstrapOperations = new LinkedList<ModelNode>();
        this.getExtensions(config, bootstrapOperations);
        this.getList(config, bootstrapOperations);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(bootstrapOperations);
        }
        Thread.currentThread().setContextClassLoader(RuntimeServer.class.getClassLoader());
        UUID grist = UUID.randomUUID();
        String tmpDir = System.getProperty("java.io.tmpdir");
        File serverTmp = TempFileManager.INSTANCE.newTempDirectory("wildfly-swarm", ".d");
        System.setProperty("jboss.server.temp.dir", serverTmp.getAbsolutePath());
        ScheduledExecutorService tempFileExecutor = Executors.newSingleThreadScheduledExecutor();
        TempFileProvider tempFileProvider = TempFileProvider.create((String)"wildfly-swarm", (ScheduledExecutorService)tempFileExecutor, (boolean)true);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                tempFileProvider.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        ArrayList<ServiceActivator> activators = new ArrayList<ServiceActivator>();
        activators.add(context -> {
            context.getServiceTarget().addService(ServiceName.of((String[])new String[]{"wildfly", "swarm", "temp-provider"}), (Service)new ValueService((Value)new ImmediateValue((Object)tempFileProvider))).install();
            context.getServiceTarget().addService(ServiceName.of((String[])new String[]{"wildfly", "swarm", "main-args"}), (Service)new ValueService((Value)new ImmediateValue((Object)config.getArgs()))).install();
        });
        for (ServerConfiguration<Fraction> eachConfig : this.configList) {
            boolean found = false;
            for (Fraction fraction : config.fractions()) {
                if (!eachConfig.getType().isAssignableFrom(fraction.getClass())) continue;
                found = true;
                activators.addAll(eachConfig.getServiceActivators(fraction));
                break;
            }
            if (found || eachConfig.isIgnorable()) continue;
            System.err.println("*** unable to find fraction for: " + eachConfig.getType());
        }
        this.serviceContainer = this.container.start(bootstrapOperations, (ContentProvider)this.contentProvider, activators);
        for (ServiceName serviceName : this.serviceContainer.getServiceNames()) {
            ServiceController serviceController = this.serviceContainer.getService(serviceName);
            StartException exception = serviceController.getStartException();
            if (exception == null) continue;
            throw exception;
        }
        ModelController controller = (ModelController)this.serviceContainer.getService(Services.JBOSS_SERVER_CONTROLLER).getValue();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.client = controller.createClient((Executor)executor);
        this.deployer = new RuntimeDeployer(this.configList, this.client, this.contentProvider, tempFileProvider);
        this.deployer.debug(this.debug);
        ArrayList<Archive> implicitDeployments = new ArrayList<Archive>();
        block4: for (ServerConfiguration serverConfiguration : this.configList) {
            for (Fraction eachFraction : config.fractions()) {
                if (!serverConfiguration.getType().isAssignableFrom(eachFraction.getClass())) continue;
                implicitDeployments.addAll(serverConfiguration.getImplicitDeployments(eachFraction));
                continue block4;
            }
        }
        for (Archive archive : implicitDeployments) {
            this.deployer.deploy(archive);
        }
        return this.deployer;
    }

    public void stop() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.serviceContainer.addTerminateListener(info -> latch.countDown());
        this.serviceContainer.shutdown();
        latch.await();
        this.deployer.stop();
        this.serviceContainer = null;
        this.client = null;
        this.deployer = null;
    }

    public Set<Class<? extends Fraction>> getFractionTypes() {
        return this.configByFractionType.keySet();
    }

    public Fraction createDefaultFor(Class<? extends Fraction> fractionClazz) {
        return this.configByFractionType.get(fractionClazz).defaultFraction();
    }

    private void applyDefaults(Container config) throws Exception {
        config.applyFractionDefaults((Server)this);
        if (!this.xmlConfig.isPresent()) {
            this.applyInterfaceDefaults(config);
        }
    }

    private void applyInterfaceDefaults(Container config) {
        if (config.ifaces().isEmpty()) {
            config.iface("public", SwarmProperties.propertyVar((String)"swarm.bind.address", (String)"0.0.0.0"));
        }
    }

    private void applySocketBindingGroupDefaults(Container config) {
        SocketBindingGroup group;
        List bindings;
        if (config.socketBindingGroups().isEmpty()) {
            config.socketBindingGroup(new SocketBindingGroup("default-sockets", "public", SwarmProperties.propertyVar((String)"swarm.port.offset", (String)"0")));
        }
        Set groupNames = config.socketBindings().keySet();
        for (String each : groupNames) {
            bindings = (List)config.socketBindings().get(each);
            group = config.getSocketBindingGroup(each);
            if (group == null) {
                throw new RuntimeException("No socket-binding-group for '" + each + "'");
            }
            for (SocketBinding binding : bindings) {
                group.socketBinding(binding);
            }
        }
        groupNames = config.outboundSocketBindings().keySet();
        for (String each : groupNames) {
            bindings = (List)config.outboundSocketBindings().get(each);
            group = config.getSocketBindingGroup(each);
            if (group == null) {
                throw new RuntimeException("No socket-binding-group for '" + each + "'");
            }
            for (SocketBinding binding : bindings) {
                group.outboundSocketBinding((OutboundSocketBinding)binding);
            }
        }
    }

    private void loadFractionConfigurations() throws Exception {
        Module m1 = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application"));
        Enumeration<URL> bootstraps = m1.getClassLoader().getResources("wildfly-swarm-bootstrap.conf");
        if (!bootstraps.hasMoreElements()) {
            bootstraps = ClassLoader.getSystemClassLoader().getResources("wildfly-swarm-bootstrap.conf");
        }
        while (bootstraps.hasMoreElements()) {
            URL each = bootstraps.nextElement();
            BufferedReader reader = new BufferedReader(new InputStreamReader(each.openStream()));
            Throwable throwable = null;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)line, (String)"runtime"));
                    List<Class<? extends ServerConfiguration>> serverConfigs = this.findServerConfigurationImpls(module);
                    for (Class<? extends ServerConfiguration> cls : serverConfigs) {
                        if (this.configList.stream().anyMatch(e -> e.getClass().equals(cls))) continue;
                        ServerConfiguration serverConfig = cls.newInstance();
                        this.configByFractionType.put(serverConfig.getType(), serverConfig);
                        this.configList.add(serverConfig);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }

    protected List<Class<? extends ServerConfiguration>> findServerConfigurationImpls(Module module) throws ModuleLoadException, IOException, NoSuchFieldException, IllegalAccessException {
        Indexer indexer = new Indexer();
        Iterator resources = module.iterateResources(PathFilters.acceptAll());
        while (resources.hasNext()) {
            Resource each = (Resource)resources.next();
            if (!each.getName().endsWith(".class")) continue;
            try {
                ClassInfo classInfo = indexer.index(each.openStream());
            }
            catch (IOException iOException) {}
        }
        Index index = indexer.complete();
        Set infos = index.getAllKnownImplementors(DotName.createSimple((String)ServerConfiguration.class.getName()));
        ArrayList<Class<? extends ServerConfiguration>> impls = new ArrayList<Class<? extends ServerConfiguration>>();
        for (ClassInfo info : infos) {
            try {
                Class cls = module.getClassLoader().loadClass(info.name().toString());
                if (Modifier.isAbstract(cls.getModifiers())) continue;
                impls.add(cls);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return impls;
    }

    private void getExtensions(Container container, List<ModelNode> list) throws Exception {
        FractionProcessor<List> consumer = (context, cfg, fraction) -> {
            try {
                Optional<ModelNode> extension = cfg.getExtension();
                extension.map(modelNode -> list.add((ModelNode)modelNode));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        this.visitFractions(container, list, consumer);
    }

    private void getList(Container config, List<ModelNode> list) throws Exception {
        if (this.xmlConfig.isPresent()) {
            this.configureFractionsFromXML(config, list);
        } else {
            this.configureInterfaces(config, list);
            this.configureSocketBindingGroups(config, list);
            this.configureFractions(config, list);
        }
    }

    private void configureInterfaces(Container config, List<ModelNode> list) {
        List ifaces = config.ifaces();
        for (Interface each : ifaces) {
            this.configureInterface(each, list);
        }
    }

    private void configureInterface(Interface iface, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set("interface", iface.getName());
        node.get("inet-address").set(new ValueExpression(iface.getExpression()));
        list.add(node);
    }

    private void configureSocketBindingGroups(Container config, List<ModelNode> list) {
        List groups = config.socketBindingGroups();
        for (SocketBindingGroup each : groups) {
            this.configureSocketBindingGroup(each, list);
        }
    }

    private void configureSocketBindingGroup(SocketBindingGroup group, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        PathAddress address = PathAddress.pathAddress((String)"socket-binding-group", (String)group.name());
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode());
        node.get("default-interface").set(group.defaultInterface());
        node.get("port-offset").set(new ValueExpression(group.portOffsetExpression()));
        list.add(node);
        this.configureSocketBindings(address, group, list);
    }

    private void configureSocketBindings(PathAddress address, SocketBindingGroup group, List<ModelNode> list) {
        List socketBindings = group.socketBindings();
        for (SocketBinding each : socketBindings) {
            this.configureSocketBinding(address, each, list);
        }
        List outboundSocketBindings = group.outboundSocketBindings();
        for (OutboundSocketBinding each : outboundSocketBindings) {
            this.configureSocketBinding(address, each, list);
        }
    }

    private void configureSocketBinding(PathAddress address, SocketBinding binding, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.append("socket-binding", binding.name()).toModelNode());
        node.get("operation").set("add");
        node.get("port").set(new ValueExpression(binding.portExpression()));
        if (binding.multicastAddress() != null) {
            node.get("multicast-address").set(binding.multicastAddress());
        }
        if (binding.multicastPortExpression() != null) {
            node.get("multicast-port").set(new ValueExpression(binding.multicastPortExpression()));
        }
        list.add(node);
    }

    private void configureSocketBinding(PathAddress address, OutboundSocketBinding binding, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.append("remote-destination-outbound-socket-binding", binding.name()).toModelNode());
        node.get("operation").set("add");
        node.get("host").set(new ValueExpression(binding.remoteHostExpression()));
        node.get("port").set(new ValueExpression(binding.remotePortExpression()));
        list.add(node);
    }

    private void configureFractionsFromXML(Container container, List<ModelNode> operationList) throws Exception {
        StandaloneXmlParser parser = new StandaloneXmlParser();
        FractionProcessor<StandaloneXmlParser> consumer = (p, cfg, fraction) -> {
            try {
                if (cfg.getSubsystemParsers().isPresent()) {
                    Map<QName, XMLElementReader<List<ModelNode>>> fractionParsers = cfg.getSubsystemParsers().get();
                    fractionParsers.forEach(p::addDelegate);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        this.visitFractions(container, parser, consumer);
        List<ModelNode> parseResult = parser.parse(this.xmlConfig.get());
        operationList.addAll(parseResult);
    }

    private void configureFractions(Container config, List<ModelNode> list) throws Exception {
        for (ServerConfiguration<Fraction> eachConfig : this.configList) {
            boolean found = false;
            for (Fraction eachFraction : config.fractions()) {
                if (!eachConfig.getType().isAssignableFrom(eachFraction.getClass())) continue;
                found = true;
                list.addAll(eachConfig.getList(eachFraction));
                break;
            }
            if (found || eachConfig.isIgnorable()) continue;
            System.err.println("*** unable to find fraction for: " + eachConfig.getType());
        }
    }

    private <T> void visitFractions(Container container, T context, FractionProcessor<T> fn) {
        for (ServerConfiguration<Fraction> eachConfig : this.configList) {
            boolean found = false;
            for (Fraction eachFraction : container.fractions()) {
                if (!eachConfig.getType().isAssignableFrom(eachFraction.getClass())) continue;
                found = true;
                fn.accept(context, eachConfig, eachFraction);
                break;
            }
            if (found || eachConfig.isIgnorable()) continue;
            System.err.println("*** unable to find fraction for: " + eachConfig.getType());
        }
    }

    private static class ExtensionOpPriorityComparator
    implements Comparator<ModelNode> {
        private ExtensionOpPriorityComparator() {
        }

        @Override
        public int compare(ModelNode left, ModelNode right) {
            PathAddress leftAddr = PathAddress.pathAddress((ModelNode)left.get("address"));
            PathAddress rightAddr = PathAddress.pathAddress((ModelNode)right.get("address"));
            String leftOpName = left.require("operation").asString();
            String rightOpName = left.require("operation").asString();
            if (leftAddr.size() == 1 && leftAddr.getElement(0).getKey().equals("extension") && leftOpName.equals("add")) {
                return -1;
            }
            if (rightAddr.size() == 1 && rightAddr.getElement(0).getKey().equals("extension") && rightOpName.equals("add")) {
                return 1;
            }
            return 0;
        }
    }

    @FunctionalInterface
    static interface FractionProcessor<T> {
        public void accept(T var1, ServerConfiguration var2, Fraction var3);
    }
}

