/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.wildfly.swarm.container.runtime.internal.Configurator;
import org.wildfly.swarm.container.runtime.internal.MarshalConfigurator;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.runtime.AbstractParserFactory;
import org.wildfly.swarm.spi.runtime.ServerConfiguration;

public class AnnotationBasedServerConfiguration
implements ServerConfiguration {
    private final Class<? extends Fraction> type;
    private boolean marshal;
    private boolean ignorable;
    private String extension;
    private List<Configurator> configurators = new ArrayList<Configurator>();
    private Class<? extends AbstractParserFactory> parserFactoryClass;
    private String defaultFractionMethodName;

    public AnnotationBasedServerConfiguration(Class<? extends Fraction> type) {
        this.type = type;
    }

    public void marshal(boolean marshal) {
        this.marshal = marshal;
        if (marshal) {
            this.configurators.add(new MarshalConfigurator());
        }
    }

    public void extension(String extension) {
        this.extension = extension;
    }

    public void ignorable(boolean ignorable) {
        this.ignorable = ignorable;
    }

    public void parserFactoryClass(Class<? extends AbstractParserFactory> parserFactoryClass) {
        this.parserFactoryClass = parserFactoryClass;
    }

    public boolean isIgnorable() {
        return this.ignorable;
    }

    public Optional<ModelNode> getExtension() {
        if (this.extension != null && !this.extension.equals("")) {
            ModelNode node = new ModelNode();
            node.get("address").set("extension", this.extension);
            node.get("operation").set("add");
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public Class getType() {
        return this.type;
    }

    public Optional<Map<QName, XMLElementReader<List<ModelNode>>>> getSubsystemParsers() throws Exception {
        if (this.parserFactoryClass == null) {
            return Optional.empty();
        }
        return AbstractParserFactory.mapParserNamespaces((AbstractParserFactory)this.parserFactoryClass.newInstance());
    }

    public List<ModelNode> getList(Fraction fraction) throws Exception {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        for (Configurator configurator : this.configurators) {
            configurator.execute(fraction, list);
        }
        return list;
    }

    public void defaultFraction(String defaultFractionMethodName) {
        this.defaultFractionMethodName = defaultFractionMethodName;
    }

    public Fraction defaultFraction() {
        Method[] methods;
        for (Method method : methods = this.type.getMethods()) {
            if (!method.getName().equals(this.defaultFractionMethodName) || !Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0) continue;
            try {
                return (Fraction)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        try {
            return this.type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

