/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.naming.ImmediateManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.selfcontained.ContentProvider;
import org.jboss.as.server.SelfContainedContainer;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.vfs.TempFileProvider;
import org.wildfly.swarm.bootstrap.logging.BackingLoggerManager;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.container.internal.Deployer;
import org.wildfly.swarm.container.internal.Server;
import org.wildfly.swarm.container.runtime.GenericParserFactory;
import org.wildfly.swarm.container.runtime.JBossLoggingManager;
import org.wildfly.swarm.container.runtime.LoggingConfigurator;
import org.wildfly.swarm.container.runtime.RuntimeDeployer;
import org.wildfly.swarm.container.runtime.SimpleContentProvider;
import org.wildfly.swarm.container.runtime.StandaloneXmlParser;
import org.wildfly.swarm.container.runtime.UUIDFactory;
import org.wildfly.swarm.container.runtime.internal.AnnotationBasedServerConfiguration;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.OutboundSocketBinding;
import org.wildfly.swarm.spi.api.ProjectStage;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.api.StageConfig;
import org.wildfly.swarm.spi.api.SwarmProperties;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;
import org.wildfly.swarm.spi.runtime.ServerConfiguration;

public class RuntimeServer
implements Server {
    private static final String BUILD_TIME_INDEX_NAME = "META-INF/swarm-jandex.idx";
    private SelfContainedContainer container = new SelfContainedContainer();
    private SimpleContentProvider contentProvider = new SimpleContentProvider();
    private ServiceContainer serviceContainer;
    private ModelControllerClient client;
    private RuntimeDeployer deployer;
    private Map<Class<? extends Fraction>, ServerConfiguration> configByFractionType = new ConcurrentHashMap<Class<? extends Fraction>, ServerConfiguration>();
    private List<ServerConfiguration<Fraction>> configList = new ArrayList<ServerConfiguration<Fraction>>();
    private Optional<URL> xmlConfig = Optional.empty();
    private BootstrapLogger LOG = BootstrapLogger.logger((String)"org.wildfly.swarm.runtime.server");
    private boolean debug;
    private Optional<ProjectStage> enabledStage = Optional.empty();

    public RuntimeServer() {
        try {
            Module loggingModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.logging", (String)"runtime"));
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)loggingModule.getClassLoader());
                System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
                System.setProperty("org.jboss.logmanager.configurator", LoggingConfigurator.class.getName());
                LogManager.getLogManager();
                BootstrapLogger.setBackingLoggerManager((BackingLoggerManager)new JBossLoggingManager());
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
        catch (ModuleLoadException e) {
            System.err.println("[WARN] logging not available, logging will not be configured");
        }
    }

    public void setXmlConfig(URL xmlConfig) {
        if (null == xmlConfig) {
            throw new IllegalArgumentException("Invalid XML config");
        }
        this.xmlConfig = Optional.of(xmlConfig);
    }

    public void setStageConfig(ProjectStage enabledConfig) {
        if (null == enabledConfig) {
            throw new IllegalArgumentException("Invalid stage config");
        }
        this.enabledStage = Optional.of(enabledConfig);
    }

    public void debug(boolean debug) {
        this.debug = debug;
    }

    public Deployer start(Container config, boolean eagerlyOpen) throws Exception {
        if (System.getProperty("swarm.http.eager") != null) {
            eagerlyOpen = true;
        }
        UUID uuid = UUIDFactory.getUUID();
        System.setProperty("jboss.server.management.uuid", uuid.toString());
        this.loadFractionConfigurations();
        this.applyDefaults(config);
        for (Fraction fraction : config.fractions()) {
            fraction.postInitialize((Fraction.PostInitContext)config.createPostInitContext());
        }
        this.applySocketBindingGroupDefaults(config);
        LinkedList<ModelNode> bootstrapOperations = new LinkedList<ModelNode>();
        if (this.enabledStage.isPresent()) {
            this.getSystemProperties(this.enabledStage, bootstrapOperations);
        }
        this.getExtensions(config, bootstrapOperations);
        this.getSubsystemConfigurations(config, bootstrapOperations);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(bootstrapOperations);
        }
        Thread.currentThread().setContextClassLoader(RuntimeServer.class.getClassLoader());
        UUID grist = UUID.randomUUID();
        File serverTmp = TempFileManager.INSTANCE.newTempDirectory("wildfly-swarm", ".d");
        System.setProperty("jboss.server.temp.dir", serverTmp.getAbsolutePath());
        ScheduledExecutorService tempFileExecutor = Executors.newSingleThreadScheduledExecutor();
        TempFileProvider tempFileProvider = TempFileProvider.create((String)"wildfly-swarm", (ScheduledExecutorService)tempFileExecutor, (boolean)true);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                tempFileProvider.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        ArrayList<ServiceActivator> activators = new ArrayList<ServiceActivator>();
        activators.add(context -> {
            context.getServiceTarget().addService(ServiceName.of((String[])new String[]{"wildfly", "swarm", "temp-provider"}), (Service)new ValueService((Value)new ImmediateValue((Object)tempFileProvider))).install();
            context.getServiceTarget().addService(ServiceName.of((String[])new String[]{"wildfly", "swarm", "main-args"}), (Service)new ValueService((Value)new ImmediateValue((Object)config.getArgs()))).install();
            if (this.enabledStage.isPresent()) {
                BinderService binderService = new BinderService("swarm/stage-config", null, true);
                context.getServiceTarget().addService(ContextNames.buildServiceName((ServiceName)ContextNames.JBOSS_CONTEXT_SERVICE_NAME, (String)"swarm/stage-config"), (Service)binderService).addDependency(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addInjection((Injector)binderService.getManagedObjectInjector(), (Object)new ImmediateManagedReferenceFactory((Object)new StageConfig(this.enabledStage.get()))).setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
        });
        for (ServerConfiguration<Fraction> eachConfig : this.configList) {
            boolean found = false;
            for (Fraction eachFraction : config.fractions()) {
                if (!eachConfig.getType().isAssignableFrom(eachFraction.getClass())) continue;
                found = true;
                activators.addAll(eachConfig.getServiceActivators(eachFraction));
                break;
            }
            if (found || eachConfig.isIgnorable()) continue;
            System.err.println("*** unable to find fraction for: " + eachConfig.getType());
        }
        this.serviceContainer = this.container.start(bootstrapOperations, (ContentProvider)this.contentProvider, activators);
        for (ServiceName serviceName : this.serviceContainer.getServiceNames()) {
            ServiceController serviceController = this.serviceContainer.getService(serviceName);
            StartException exception = serviceController.getStartException();
            if (exception == null) continue;
            throw exception;
        }
        Opener opener = this.tryToAddGateHandlers();
        ModelController controller = (ModelController)this.serviceContainer.getService(Services.JBOSS_SERVER_CONTROLLER).getValue();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        if (eagerlyOpen) {
            opener.open();
        }
        this.client = controller.createClient((Executor)executor);
        this.deployer = new RuntimeDeployer(opener, this.serviceContainer, this.configList, this.client, this.contentProvider, tempFileProvider);
        this.deployer.debug(this.debug);
        this.serviceContainer.addService(ServiceName.of((String[])new String[]{"swarm", "deployer"}), (Service)new ValueService((Value)new ImmediateValue((Object)this.deployer))).install();
        ArrayList implicitDeployments = new ArrayList();
        block4: for (ServerConfiguration<Fraction> eachConfig : this.configList) {
            for (Fraction eachFraction : config.fractions()) {
                if (!eachConfig.getType().isAssignableFrom(eachFraction.getClass())) continue;
                implicitDeployments.addAll(eachConfig.getImplicitDeployments(eachFraction));
                continue block4;
            }
        }
        for (Archive each : implicitDeployments) {
            this.deployer.deploy(each);
        }
        return this.deployer;
    }

    private void getSystemProperties(Optional<ProjectStage> enabledStage, LinkedList<ModelNode> bootstrapOperations) {
        if (!enabledStage.isPresent()) {
            throw new IllegalArgumentException("No stage config present");
        }
        ProjectStage projectStage = enabledStage.get();
        Map properties = projectStage.getProperties();
        for (String key : properties.keySet()) {
            ModelNode modelNode = new ModelNode();
            modelNode.get("operation").set("add");
            modelNode.get("address").set("system-property", key);
            modelNode.get("value").set((String)properties.get(key));
            bootstrapOperations.add(modelNode);
        }
    }

    protected Opener tryToAddGateHandlers() throws Exception {
        try {
            Module undertowRuntime = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.undertow", (String)"runtime"));
            Class wrapperClass = undertowRuntime.getClassLoader().loadClass("org.wildfly.swarm.undertow.runtime.GateHandlerWrapper");
            Object wrapperInstance = wrapperClass.newInstance();
            ServiceName listenerRoot = ServiceName.of((String[])new String[]{"jboss", "undertow", "listener"});
            List names = this.serviceContainer.getServiceNames();
            for (ServiceName name : names) {
                if (!listenerRoot.isParentOf(name)) continue;
                ServiceController service = this.serviceContainer.getService(name);
                Object value = service.getValue();
                block3: for (Class<?> cls = value.getClass(); cls != null; cls = cls.getSuperclass()) {
                    Method[] methods = cls.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        Method method = methods[i];
                        if (!method.getName().equals("addWrapperHandler")) continue;
                        method.setAccessible(true);
                        method.invoke(value, wrapperInstance);
                        break block3;
                    }
                }
                service.setMode(ServiceController.Mode.ACTIVE);
            }
            return (Opener)wrapperInstance;
        }
        catch (ModuleLoadException moduleLoadException) {
            return null;
        }
    }

    public void stop() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.serviceContainer.addTerminateListener(info -> latch.countDown());
        this.serviceContainer.shutdown();
        latch.await();
        this.deployer.stop();
        this.serviceContainer = null;
        this.client = null;
        this.deployer = null;
    }

    public Set<Class<? extends Fraction>> getFractionTypes() {
        return this.configByFractionType.keySet();
    }

    public Fraction createDefaultFor(Class<? extends Fraction> fractionClazz) {
        return this.configByFractionType.get(fractionClazz).defaultFraction();
    }

    private void applyDefaults(Container config) throws Exception {
        config.applyFractionDefaults((Server)this);
        this.applyInterfaceDefaults(config);
    }

    private void applyInterfaceDefaults(Container config) {
        if (config.ifaces().isEmpty()) {
            config.iface("public", SwarmProperties.propertyVar((String)"swarm.bind.address", (String)"0.0.0.0"));
        }
    }

    private void applySocketBindingGroupDefaults(Container config) {
        SocketBindingGroup group;
        List bindings;
        if (config.socketBindingGroups().isEmpty()) {
            config.socketBindingGroup(new SocketBindingGroup("default-sockets", "public", SwarmProperties.propertyVar((String)"swarm.port.offset", (String)"0")));
        }
        Set groupNames = config.socketBindings().keySet();
        for (String each : groupNames) {
            bindings = (List)config.socketBindings().get(each);
            group = config.getSocketBindingGroup(each);
            if (group == null) {
                throw new RuntimeException("No socket-binding-group for '" + each + "'");
            }
            for (SocketBinding binding : bindings) {
                group.socketBinding(binding);
            }
        }
        groupNames = config.outboundSocketBindings().keySet();
        for (String each : groupNames) {
            bindings = (List)config.outboundSocketBindings().get(each);
            group = config.getSocketBindingGroup(each);
            if (group == null) {
                throw new RuntimeException("No socket-binding-group for '" + each + "'");
            }
            for (SocketBinding binding : bindings) {
                group.outboundSocketBinding((OutboundSocketBinding)binding);
            }
        }
    }

    private void loadFractionConfigurations() throws Exception {
        Module m1 = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application"));
        ArrayList<Index> indexes = new ArrayList<Index>();
        this.resolveBuildTimeIndex(Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.container", (String)"runtime")), indexes);
        this.resolveBuildTimeIndex(Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.spi", (String)"runtime")), indexes);
        this.resolveBuildTimeIndex(Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.spi", (String)"main")), indexes);
        Enumeration<URL> bootstraps = m1.getClassLoader().getResources("wildfly-swarm-bootstrap.conf");
        if (!bootstraps.hasMoreElements()) {
            bootstraps = ClassLoader.getSystemClassLoader().getResources("wildfly-swarm-bootstrap.conf");
        }
        while (bootstraps.hasMoreElements()) {
            URL each = bootstraps.nextElement();
            BufferedReader reader = new BufferedReader(new InputStreamReader(each.openStream()));
            Throwable throwable = null;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)line, (String)"runtime"));
                    List<Class<? extends ServerConfiguration>> serverConfigs = this.findServerConfigurationImpls(module, indexes);
                    for (Class<? extends ServerConfiguration> cls : serverConfigs) {
                        if (this.configList.stream().anyMatch(e -> e.getClass().equals(cls))) continue;
                        ServerConfiguration serverConfig = cls.newInstance();
                        this.configByFractionType.put(serverConfig.getType(), serverConfig);
                        this.configList.add((ServerConfiguration<Fraction>)serverConfig);
                    }
                    module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)line, (String)"api"));
                    List<ServerConfiguration> serverConfigInstances = this.findAnnotationServerConfigurations(module, indexes);
                    for (ServerConfiguration serverConfigInstance : serverConfigInstances) {
                        if (this.configList.stream().anyMatch(e -> e.getType().equals(serverConfigInstance.getType()))) continue;
                        this.configByFractionType.put(serverConfigInstance.getType(), serverConfigInstance);
                        this.configList.add((ServerConfiguration<Fraction>)serverConfigInstance);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }

    protected List<Class<? extends ServerConfiguration>> findServerConfigurationImpls(Module module, List<Index> parentIndexes) throws ModuleLoadException, IOException, NoSuchFieldException, IllegalAccessException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        this.resolveBuildTimeIndex(module, indexes);
        indexes.addAll(parentIndexes);
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])((IndexView[])indexes.toArray(new Index[indexes.size()])));
        ArrayList<Class<? extends ServerConfiguration>> impls = new ArrayList<Class<? extends ServerConfiguration>>();
        Set infos = compositeIndex.getAllKnownImplementors(DotName.createSimple((String)ServerConfiguration.class.getName()));
        for (ClassInfo info : infos) {
            if (info.name().toString().equals(AnnotationBasedServerConfiguration.class.getName())) continue;
            try {
                Class cls = module.getClassLoader().loadClass(info.name().toString());
                if (Modifier.isAbstract(cls.getModifiers())) continue;
                impls.add(cls);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return impls;
    }

    protected List<ServerConfiguration> findAnnotationServerConfigurations(Module apiModule, List<Index> parentIndexes) throws ModuleLoadException, IOException, NoSuchFieldException, IllegalAccessException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        this.resolveBuildTimeIndex(apiModule, indexes);
        indexes.addAll(parentIndexes);
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])((IndexView[])indexes.toArray(new Index[indexes.size()])));
        ArrayList<ServerConfiguration> impls = new ArrayList<ServerConfiguration>();
        DotName configAnno = DotName.createSimple((String)Configuration.class.getName());
        Set infos = compositeIndex.getAllKnownImplementors(DotName.createSimple((String)Fraction.class.getName()));
        for (ClassInfo info : infos) {
            for (AnnotationInstance anno : info.classAnnotations()) {
                if (!anno.name().equals((Object)configAnno)) continue;
                try {
                    ServerConfiguration config = this.fromAnnotation(apiModule, anno);
                    impls.add(config);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return impls;
    }

    protected ServerConfiguration fromAnnotation(Module apiModule, AnnotationInstance anno) throws ClassNotFoundException, ModuleLoadException {
        AnnotationValue marshalValue = anno.value("marshal");
        AnnotationValue ignorableValue = anno.value("ignorable");
        AnnotationValue extensionValue = anno.value("extension");
        AnnotationValue parserFactoryClassNameValue = anno.value("parserFactoryClassName");
        AnnotationValue extensionClassNameValue = anno.value("extensionClassName");
        AnnotationValue deploymentModulesValue = anno.value("deploymentModules");
        boolean marshal = marshalValue != null ? marshalValue.asBoolean() : false;
        boolean ignorable = ignorableValue != null ? ignorableValue.asBoolean() : false;
        String extension = extensionValue != null ? extensionValue.asString() : null;
        String parserFactoryClass = parserFactoryClassNameValue != null ? parserFactoryClassNameValue.asString() : null;
        String extensionClass = extensionClassNameValue != null ? extensionClassNameValue.asString() : null;
        String[] deploymentModules = deploymentModulesValue != null ? deploymentModulesValue.asStringArray() : new String[]{};
        Module mainModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)apiModule.getIdentifier().getName(), (String)"main"));
        Class fractionClass = mainModule.getClassLoader().loadClass(anno.target().asClass().name().toString());
        AnnotationBasedServerConfiguration serverConfig = new AnnotationBasedServerConfiguration(fractionClass);
        serverConfig.ignorable(ignorable);
        serverConfig.extension(extension);
        serverConfig.marshal(marshal);
        if (parserFactoryClass != null && !parserFactoryClass.equals("")) {
            Module runtimeModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)apiModule.getIdentifier().getName(), (String)"runtime"));
            Class parserFractoryClass = runtimeModule.getClassLoader().loadClass(parserFactoryClass);
            serverConfig.parserFactoryClass(parserFractoryClass);
        } else if (extension != null && !extension.equals("")) {
            Module extensionModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)extension));
            if (extensionClass == null || !extensionClass.equalsIgnoreCase("none")) {
                if (extensionClass != null && !extensionClass.equals("")) {
                    Class extCls = extensionModule.getClassLoader().loadClass(extensionClass);
                    try {
                        Extension ext = (Extension)extCls.newInstance();
                        GenericParserFactory parserFactory = new GenericParserFactory(ext);
                        serverConfig.parserFactory(parserFactory);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                } else {
                    ServiceLoader extensions = extensionModule.loadService(Extension.class);
                    Iterator extensionIter = extensions.iterator();
                    if (extensionIter.hasNext()) {
                        Extension ext = (Extension)extensionIter.next();
                        GenericParserFactory parserFactory = new GenericParserFactory(ext);
                        serverConfig.parserFactory(parserFactory);
                    }
                    if (extensionIter.hasNext()) {
                        throw new RuntimeException("Fraction \"" + fractionClass.getName() + "\" was configured using @Configuration with an extension=''," + " but has multiple extension classes.  Please use extensionClassName='' to specify exactly one.");
                    }
                }
            }
        }
        List fractionMethods = anno.target().asClass().methods();
        DotName defaultAnno = DotName.createSimple((String)Default.class.getName());
        boolean foundDefault = false;
        for (MethodInfo each : fractionMethods) {
            if (!each.hasAnnotation(defaultAnno)) continue;
            if (!each.parameters().isEmpty()) {
                throw new RuntimeException("Method marked @Default must require zero parameters");
            }
            if (!Modifier.isStatic(each.flags())) {
                throw new RuntimeException("Method marked @Default must be static");
            }
            if (foundDefault) {
                throw new RuntimeException("Multiple methods found marked as @Default");
            }
            foundDefault = true;
            serverConfig.defaultFraction(each.name());
        }
        serverConfig.setDeploymentModules(deploymentModules);
        return serverConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveBuildTimeIndex(Module module, List<Index> indexes) {
        try {
            Enumeration indexFiles = module.getClassLoader().findResources(BUILD_TIME_INDEX_NAME, false);
            while (indexFiles.hasMoreElements()) {
                URL next = (URL)indexFiles.nextElement();
                InputStream input = next.openStream();
                IndexReader reader = new IndexReader(input);
                Index index = reader.read();
                try {
                    indexes.add(index);
                }
                finally {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void resolveRuntimeIndex(Module module, List<Index> indexes) throws ModuleLoadException {
        Indexer indexer = new Indexer();
        Iterator resources = module.iterateResources(PathFilters.acceptAll());
        while (resources.hasNext()) {
            Resource each = (Resource)resources.next();
            if (!each.getName().endsWith(".class")) continue;
            try {
                ClassInfo classInfo = indexer.index(each.openStream());
            }
            catch (IOException iOException) {}
        }
        indexes.add(indexer.complete());
    }

    private void getExtensions(Container container, List<ModelNode> list) throws Exception {
        HashSet extensionNodes = new HashSet();
        FractionProcessor<List> consumer = (context, cfg, fraction) -> {
            try {
                Optional extension = cfg.getExtension();
                extension.map(modelNode -> extensionNodes.add(modelNode));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        this.visitFractions(container, list, consumer);
        list.addAll(extensionNodes);
    }

    private void getSubsystemConfigurations(Container config, List<ModelNode> list) throws Exception {
        if (this.xmlConfig.isPresent()) {
            this.configureFractionsFromXML(config, list);
        }
        this.configureFractions(config, list);
        this.configureInterfaces(config, list);
        this.configureSocketBindingGroups(config, list);
    }

    private void configureInterfaces(Container config, List<ModelNode> list) {
        List ifaces = config.ifaces();
        for (Interface each : ifaces) {
            this.configureInterface(each, list);
        }
    }

    private void configureInterface(Interface iface, List<ModelNode> list) {
        if (this.hasInterface(iface, list)) {
            System.err.println("has interface, not adding");
            return;
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set("interface", iface.getName());
        node.get("inet-address").set(new ValueExpression(iface.getExpression()));
        list.add(node);
    }

    private boolean hasInterface(Interface iface, List<ModelNode> list) {
        return list.stream().anyMatch(e -> {
            if (!e.get("operation").asString().equals("add")) {
                return false;
            }
            ModelNode addr = e.get("address");
            if (addr.getType() != ModelType.LIST) {
                return false;
            }
            List addrList = addr.asList();
            if (addrList.size() != 1) {
                return false;
            }
            Property addrProp = ((ModelNode)addrList.get(0)).asProperty();
            String propName = addrProp.getName();
            String propValue = addrProp.getValue().asString();
            boolean result = propName.equals("interface") && propValue.equals(iface.getName());
            return result;
        });
    }

    private void configureSocketBindingGroups(Container config, List<ModelNode> list) {
        List groups = config.socketBindingGroups();
        for (SocketBindingGroup each : groups) {
            this.configureSocketBindingGroup(each, list);
        }
    }

    private void configureSocketBindingGroup(SocketBindingGroup group, List<ModelNode> list) {
        if (this.hasSocketBindingGroup(list)) {
            return;
        }
        ModelNode node = new ModelNode();
        PathAddress address = PathAddress.pathAddress((String)"socket-binding-group", (String)group.name());
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode());
        node.get("default-interface").set(group.defaultInterface());
        node.get("port-offset").set(new ValueExpression(group.portOffsetExpression()));
        list.add(node);
        this.configureSocketBindings(address, group, list);
    }

    private boolean hasSocketBindingGroup(List<ModelNode> list) {
        return list.stream().anyMatch(e -> {
            if (!e.get("operation").asString().equals("add")) {
                return false;
            }
            ModelNode addr = e.get("address");
            if (addr.getType() != ModelType.LIST) {
                return false;
            }
            List addrList = addr.asList();
            if (addrList.size() != 1) {
                return false;
            }
            Property addrProp = ((ModelNode)addrList.get(0)).asProperty();
            String propName = addrProp.getName();
            String propValue = addrProp.getValue().asString();
            boolean result = propName.equals("socket-binding-group");
            return result;
        });
    }

    private void configureSocketBindings(PathAddress address, SocketBindingGroup group, List<ModelNode> list) {
        List socketBindings = group.socketBindings();
        for (SocketBinding each : socketBindings) {
            this.configureSocketBinding(address, each, list);
        }
        List outboundSocketBindings = group.outboundSocketBindings();
        for (OutboundSocketBinding each : outboundSocketBindings) {
            this.configureSocketBinding(address, each, list);
        }
    }

    private void configureSocketBinding(PathAddress address, SocketBinding binding, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.append("socket-binding", binding.name()).toModelNode());
        node.get("operation").set("add");
        node.get("port").set(new ValueExpression(binding.portExpression()));
        if (binding.multicastAddress() != null) {
            node.get("multicast-address").set(binding.multicastAddress());
        }
        if (binding.multicastPortExpression() != null) {
            node.get("multicast-port").set(new ValueExpression(binding.multicastPortExpression()));
        }
        list.add(node);
    }

    private void configureSocketBinding(PathAddress address, OutboundSocketBinding binding, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.append("remote-destination-outbound-socket-binding", binding.name()).toModelNode());
        node.get("operation").set("add");
        node.get("host").set(new ValueExpression(binding.remoteHostExpression()));
        node.get("port").set(new ValueExpression(binding.remotePortExpression()));
        list.add(node);
    }

    private void configureFractionsFromXML(Container container, List<ModelNode> operationList) throws Exception {
        StandaloneXmlParser parser = new StandaloneXmlParser();
        FractionProcessor<StandaloneXmlParser> consumer = (p, cfg, fraction) -> {
            try {
                if (cfg.getSubsystemParsers().isPresent()) {
                    Map fractionParsers = (Map)cfg.getSubsystemParsers().get();
                    fractionParsers.forEach((k, v) -> {
                        try {
                            System.err.println("Registered parser: " + k.getNamespaceURI());
                            parser.addDelegate((QName)k, (XMLElementReader<List<ModelNode>>)v);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        this.visitFractions(container, parser, consumer);
        List<ModelNode> parseResult = parser.parse(this.xmlConfig.get());
        operationList.addAll(parseResult);
    }

    private void configureFractions(Container config, List<ModelNode> list) throws Exception {
        for (ServerConfiguration<Fraction> eachConfig : this.configList) {
            boolean found = false;
            for (Fraction eachFraction : config.fractions()) {
                if (!eachConfig.getType().isAssignableFrom(eachFraction.getClass())) continue;
                found = true;
                List subList = eachConfig.getList(eachFraction);
                if (this.isAlreadyConfigured(subList, list)) break;
                list.addAll(subList);
                break;
            }
            if (found || eachConfig.isIgnorable()) continue;
            System.err.println("*** unable to find fraction for: " + eachConfig.getType());
        }
    }

    private boolean isAlreadyConfigured(List<ModelNode> subList, List<ModelNode> list) {
        if (subList.isEmpty()) {
            return false;
        }
        ModelNode head = subList.get(0);
        return list.stream().anyMatch(e -> e.get("address").equals(head.get("address")));
    }

    private <T> void visitFractions(Container container, T context, FractionProcessor<T> fn) {
        for (ServerConfiguration<Fraction> eachConfig : this.configList) {
            boolean found = false;
            for (Fraction eachFraction : container.fractions()) {
                if (!eachConfig.getType().isAssignableFrom(eachFraction.getClass())) continue;
                found = true;
                fn.accept(context, eachConfig, eachFraction);
                break;
            }
            if (found || eachConfig.isIgnorable()) continue;
            System.err.println("*** unable to find fraction for: " + eachConfig.getType());
        }
    }

    public static interface Opener {
        public void open();
    }

    private static class ExtensionOpPriorityComparator
    implements Comparator<ModelNode> {
        private ExtensionOpPriorityComparator() {
        }

        @Override
        public int compare(ModelNode left, ModelNode right) {
            PathAddress leftAddr = PathAddress.pathAddress((ModelNode)left.get("address"));
            PathAddress rightAddr = PathAddress.pathAddress((ModelNode)right.get("address"));
            String leftOpName = left.require("operation").asString();
            String rightOpName = left.require("operation").asString();
            if (leftAddr.size() == 1 && leftAddr.getElement(0).getKey().equals("extension") && leftOpName.equals("add")) {
                return -1;
            }
            if (rightAddr.size() == 1 && rightAddr.getElement(0).getKey().equals("extension") && rightOpName.equals("add")) {
                return 1;
            }
            return 0;
        }
    }

    @FunctionalInterface
    static interface FractionProcessor<T> {
        public void accept(T var1, ServerConfiguration var2, Fraction var3);
    }
}

