/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.ArtifactManager;
import org.wildfly.swarm.ContainerFactory;
import org.wildfly.swarm.container.Container;

public class Swarm {
    public static ArtifactManager ARTIFACT_MANAGER;

    public static void main(String ... args) throws Exception {
        Module bootstrap;
        ServiceLoader factory;
        Iterator factoryIter;
        if (System.getProperty("boot.module.loader") == null) {
            System.setProperty("boot.module.loader", "org.wildfly.swarm.bootstrap.modules.BootModuleLoader");
        }
        if (!(factoryIter = (factory = (bootstrap = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application"))).loadService(ContainerFactory.class)).iterator()).hasNext()) {
            Swarm.simpleMain(args);
        } else {
            Swarm.factoryMain((ContainerFactory)factoryIter.next(), args);
        }
    }

    public static void simpleMain(String ... args) throws Exception {
        Container container = new Container().start();
        container.deploy();
    }

    public static void factoryMain(ContainerFactory factory, String ... args) throws Exception {
        Container container = factory.newContainer(args).start();
        container.deploy();
    }

    public static ArtifactManager artifactManager() throws IOException {
        if (ARTIFACT_MANAGER == null) {
            ARTIFACT_MANAGER = new ArtifactManager();
        }
        return ARTIFACT_MANAGER;
    }

    public static JavaArchive artifact(String gav) throws Exception {
        return Swarm.artifactManager().artifact(gav);
    }

    public static JavaArchive artifact(String gav, String asName) throws Exception {
        return Swarm.artifactManager().artifact(gav, asName);
    }

    public static List<JavaArchive> allArtifacts() throws Exception {
        return Swarm.artifactManager().allArtifacts();
    }
}

