/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.wildfly.swarm.container.DefaultDeploymentFactory;
import org.wildfly.swarm.container.JARArchive;

public class DefaultJarDeploymentFactory
extends DefaultDeploymentFactory {
    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public String getType() {
        return "jar";
    }

    @Override
    public Archive create() throws Exception {
        JARArchive archive = (JARArchive)ShrinkWrap.create(JARArchive.class, (String)this.determineName());
        this.setup(archive);
        return archive;
    }

    protected String determineName() {
        return DefaultDeploymentFactory.determineName(".jar");
    }

    @Override
    public boolean setupUsingMaven(final Archive<?> archive) throws Exception {
        Path pwd = Paths.get(System.getProperty("user.dir"), new String[0]);
        final Path classes = pwd.resolve("target").resolve("classes");
        boolean success = false;
        if (Files.exists(classes, new LinkOption[0])) {
            success = true;
            Files.walkFileTree(classes, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = classes.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), DefaultJarDeploymentFactory.this.convertSeparators(simple));
                    return super.visitFile(file, attrs);
                }
            });
        }
        return success;
    }
}

