/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.ExclusionsType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.JBossDeploymentStructureDescriptor;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.ModuleDependencyType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.ModuleExclusionType;
import org.wildfly.swarm.container.util.ClassLoading;

public class JBossDeploymentStructureAsset
implements Asset {
    private final JBossDeploymentStructureDescriptor descriptor;

    public JBossDeploymentStructureAsset() {
        this.descriptor = ClassLoading.withTCCL(Descriptors.class.getClassLoader(), () -> (JBossDeploymentStructureDescriptor)Descriptors.create(JBossDeploymentStructureDescriptor.class));
    }

    public JBossDeploymentStructureAsset(InputStream fromStream) {
        this.descriptor = ClassLoading.withTCCL(Descriptors.class.getClassLoader(), () -> (JBossDeploymentStructureDescriptor)Descriptors.importAs(JBossDeploymentStructureDescriptor.class).fromStream(fromStream));
    }

    public void addModule(String name, String slot) {
        DependenciesType dependencies = this.descriptor.getOrCreateDeployment().getOrCreateDependencies();
        List modules = dependencies.getAllModule();
        for (ModuleDependencyType each : modules) {
            String existingSlot = each.getSlot();
            if (!name.equals(each.getName()) || !slot.equals(existingSlot == null ? "main" : existingSlot)) continue;
            return;
        }
        dependencies.createModule().name(name).slot(slot);
    }

    public void excludeModule(String name, String slot) {
        ExclusionsType exclusions = this.descriptor.getOrCreateDeployment().getOrCreateExclusions();
        List modules = exclusions.getAllModule();
        for (ModuleExclusionType each : modules) {
            String existingSlot = each.getSlot();
            if (!name.equals(each.getName()) || !slot.equals(existingSlot == null ? "main" : existingSlot)) continue;
            return;
        }
        exclusions.createModule().name(name).slot(slot);
    }

    public InputStream openStream() {
        String output = this.descriptor.exportAsString();
        return new ByteArrayInputStream(output.getBytes());
    }
}

