/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.UUID;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.importer.ZipImporter;

public abstract class DefaultDeploymentFactory {
    protected static String determineName(String suffix) {
        String prop = System.getProperty("swarm.app.path");
        if (prop != null) {
            File file = new File(prop);
            String name = file.getName();
            if (name.endsWith(suffix)) {
                return name;
            }
            return name + suffix;
        }
        prop = System.getProperty("swarm.app.artifact");
        if (prop != null) {
            return prop;
        }
        return UUID.randomUUID().toString() + suffix;
    }

    public abstract int getPriority();

    public abstract String getType();

    public abstract Archive create() throws Exception;

    protected String convertSeparators(Path path) {
        String convertedPath = path.toString();
        if (convertedPath.contains(File.separator)) {
            convertedPath = convertedPath.replace(File.separator, "/");
        }
        return convertedPath;
    }

    public boolean setup(Archive<?> archive) throws Exception {
        return this.setupUsingAppPath(archive) || this.setupUsingAppArtifact(archive) || this.setupUsingMaven(archive);
    }

    protected boolean setupUsingAppPath(final Archive<?> archive) throws IOException {
        String appPath = System.getProperty("swarm.app.path");
        if (appPath != null) {
            final Path path = Paths.get(appPath, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path simple = path.relativize(file);
                        archive.add((Asset)new FileAsset(file.toFile()), DefaultDeploymentFactory.this.convertSeparators(simple));
                        return super.visitFile(file, attrs);
                    }
                });
            } else {
                ((ZipImporter)archive.as(ZipImporter.class)).importFrom(path.toFile());
            }
            return true;
        }
        return false;
    }

    protected boolean setupUsingAppArtifact(Archive<?> archive) throws IOException {
        String appArtifact = System.getProperty("swarm.app.artifact");
        if (appArtifact != null) {
            try (InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("_bootstrap/" + appArtifact);){
                ((ZipImporter)archive.as(ZipImporter.class)).importFrom(in);
            }
            return true;
        }
        return false;
    }

    protected abstract boolean setupUsingMaven(Archive<?> var1) throws Exception;
}

