/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmDependenciesConf;

public class ArtifactManager {
    private final WildFlySwarmDependenciesConf deps;

    public ArtifactManager(WildFlySwarmDependenciesConf deps) {
        this.deps = deps;
    }

    public ArtifactManager(InputStream in) throws IOException {
        this.deps = new WildFlySwarmDependenciesConf(in);
    }

    public ArtifactManager() throws IOException {
        InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("META-INF/wildfly-swarm-dependencies.conf");
        this.deps = in != null ? new WildFlySwarmDependenciesConf(in) : null;
    }

    public JavaArchive artifact(String gav) throws IOException, ModuleLoadException {
        return this.artifact(gav, null);
    }

    public JavaArchive artifact(String gav, String asName) throws IOException, ModuleLoadException {
        File file = this.findFile(gav);
        if (file == null) {
            throw new RuntimeException("Artifact not found.");
        }
        return (JavaArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)(asName == null ? file.getName() : asName))).importFrom(file)).as(JavaArchive.class);
    }

    public List<JavaArchive> allArtifacts() throws IOException {
        ArrayList<JavaArchive> archives;
        block4: {
            block3: {
                archives = new ArrayList<JavaArchive>();
                if (this.deps == null) break block3;
                for (MavenArtifactDescriptor each : this.deps.getPrimaryDependencies()) {
                    File artifact = MavenResolvers.get().resolveJarArtifact(each.mscCoordinates());
                    archives.add((JavaArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)artifact.getName())).importFrom(artifact)).as(JavaArchive.class));
                }
                break block4;
            }
            String classpath = System.getProperty("java.class.path");
            String javaHome = System.getProperty("java.home");
            Path pwd = Paths.get(System.getProperty("user.dir"), new String[0]);
            if (classpath == null) break block4;
            for (String element : classpath.split(File.pathSeparator)) {
                File artifact;
                if (element.startsWith(javaHome) || (artifact = new File(element)).toPath().startsWith(pwd)) continue;
                if (artifact.isFile()) {
                    archives.add((JavaArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)artifact.getName())).importFrom(artifact)).as(JavaArchive.class));
                    continue;
                }
                archives.add((JavaArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class)).importDirectory(artifact).as(JavaArchive.class));
            }
        }
        return archives;
    }

    private File findFile(String gav) throws IOException, ModuleLoadException {
        String[] parts = gav.split(":");
        if (parts.length < 2) {
            throw new RuntimeException("GAV must includes at least 2 segments");
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String packaging = "jar";
        String version = null;
        String classifier = "";
        if (parts.length == 3) {
            version = parts[2];
        }
        if (parts.length == 4) {
            packaging = parts[2];
            version = parts[3];
        }
        if (parts.length == 5) {
            packaging = parts[2];
            version = parts[3];
            classifier = parts[4];
        }
        if (version != null && (version.isEmpty() || version.equals("*"))) {
            version = null;
        }
        if (version == null) {
            version = this.determineVersionViaDependenciesConf(groupId, artifactId, packaging, classifier);
        }
        if (version == null) {
            version = this.determineVersionViaClasspath(groupId, artifactId, packaging, classifier);
        }
        if (version == null) {
            throw new RuntimeException("Unable to determine version number from GAV: " + gav);
        }
        return MavenResolvers.get().resolveArtifact(new ArtifactCoordinates(groupId, artifactId, version, classifier == null ? "" : classifier), packaging);
    }

    String determineVersionViaDependenciesConf(String groupId, String artifactId, String packaging, String classifier) throws IOException {
        MavenArtifactDescriptor found;
        if (this.deps != null && (found = this.deps.find(groupId, artifactId, packaging, classifier)) != null) {
            return found.version();
        }
        return null;
    }

    private String determineVersionViaClasspath(String groupId, String artifactId, String packaging, String classifier) {
        String regexp = ".*" + artifactId + "-(.+)" + (classifier.length() == 0 ? "" : "-" + classifier) + "." + packaging;
        Pattern pattern = Pattern.compile(regexp);
        for (String element : System.getProperty("java.class.path").split(File.pathSeparator)) {
            Matcher matcher = pattern.matcher(element);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

