/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.wildfly.swarm.internal.FileSystemLayout;

public class GradleFileSystemLayout
extends FileSystemLayout {
    private static final String BUILD = "build";
    private static final String CLASSES = "classes";
    private static final String MAIN = "main";
    private static final String RESOURCES = "resources";
    private static final String SRC = "src";
    private static final String WEBAPP = "webapp";
    private final Path rootPath;

    GradleFileSystemLayout(String root) {
        this.rootPath = Paths.get(root, new String[0]);
    }

    @Override
    public String determinePackagingType() {
        if (this.resolveSrcWebAppDir().toFile().exists()) {
            return "war";
        }
        return "jar";
    }

    @Override
    public Path resolveBuildClassesDir() {
        return this.rootPath.resolve(BUILD).resolve(CLASSES).resolve(MAIN);
    }

    @Override
    public Path resolveBuildResourcesDir() {
        return this.rootPath.resolve(BUILD).resolve(RESOURCES).resolve(MAIN);
    }

    @Override
    public Path resolveSrcWebAppDir() {
        return this.rootPath.resolve(SRC).resolve(MAIN).resolve(WEBAPP);
    }
}

