/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.Swarm;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.util.BootstrapProperties;
import org.wildfly.swarm.container.DeploymentException;
import org.wildfly.swarm.container.internal.Deployer;
import org.wildfly.swarm.container.runtime.deployments.DefaultDeploymentCreator;
import org.wildfly.swarm.container.runtime.wildfly.SimpleContentProvider;
import org.wildfly.swarm.internal.ArtifactManager;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.ArchiveMetadataProcessor;
import org.wildfly.swarm.spi.api.ArchivePreparer;
import org.wildfly.swarm.spi.api.DependenciesContainer;

@Singleton
public class RuntimeDeployer
implements Deployer {
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.deployer");
    private static final String CLASS_SUFFIX = ".class";
    private String defaultDeploymentType;
    @Inject
    private ModelControllerClient client;
    @Inject
    private SimpleContentProvider contentProvider;
    @Inject
    private TempFileProvider tempFileProvider;
    @Inject
    private DefaultDeploymentCreator defaultDeploymentCreator;
    private final List<Closeable> mountPoints = new ArrayList<Closeable>();
    private boolean debug = false;
    @Inject
    private Instance<ArchivePreparer> archivePreparers;
    @Inject
    private Instance<ArchiveMetadataProcessor> archiveMetadataProcessors;

    @Override
    public void deploy() throws DeploymentException {
        Archive<?> deployment = this.createDefaultDeployment();
        if (deployment == null) {
            throw SwarmMessages.MESSAGES.cannotCreateDefaultDeployment();
        }
        this.deploy(deployment);
    }

    @Override
    public void deploy(Collection<Path> pathsToDeploy) throws DeploymentException {
        if (pathsToDeploy.isEmpty()) {
            LOG.warn((Object)SwarmMessages.MESSAGES.noDeploymentsSpecified());
            return;
        }
        RuntimeDeployer.archives(pathsToDeploy).forEach(e -> {
            try {
                this.deploy((Archive<?>)e);
            }
            catch (DeploymentException e1) {
                e1.printStackTrace();
            }
        });
    }

    protected static Stream<Archive> archives(Collection<Path> paths) {
        return paths.stream().map(path -> {
            String simpleName = path.getFileName().toString();
            Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)simpleName);
            ((ZipImporter)archive.as(ZipImporter.class)).importFrom(path.toFile());
            return archive;
        });
    }

    @Override
    public Archive<?> createDefaultDeployment() {
        return this.defaultDeploymentCreator.createDefaultDeployment(this.determineDeploymentType());
    }

    private String determineDeploymentType() {
        if (this.defaultDeploymentType == null) {
            this.defaultDeploymentType = this.determineDeploymentTypeInternal();
            System.setProperty("swarm.default.deployment.type", this.defaultDeploymentType);
        }
        return this.defaultDeploymentType;
    }

    private String determineDeploymentTypeInternal() {
        int dotLoc;
        String artifact = System.getProperty("swarm.app.path");
        if (artifact != null && (dotLoc = artifact.lastIndexOf(46)) >= 0) {
            return artifact.substring(dotLoc + 1);
        }
        artifact = System.getProperty("swarm.app.artifact");
        if (artifact != null && (dotLoc = artifact.lastIndexOf(46)) >= 0) {
            return artifact.substring(dotLoc + 1);
        }
        FileSystemLayout fsLayout = FileSystemLayout.create();
        return fsLayout.determinePackagingType();
    }

    public void debug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void deploy(Archive<?> deployment) throws DeploymentException {
        DependenciesContainer depContainer;
        if (deployment instanceof DependenciesContainer && (depContainer = (DependenciesContainer)deployment).hasMarker("org.wildfly.swarm.allDependencies") && !depContainer.hasMarker("org.wildfly.swarm.allDependencies.added")) {
            try {
                ApplicationEnvironment appEnv = ApplicationEnvironment.get();
                if (ApplicationEnvironment.Mode.UBERJAR == appEnv.getMode()) {
                    ArtifactManager artifactManager = Swarm.artifactManager();
                    for (String gav : appEnv.getDependencies()) {
                        depContainer.addAsLibraries(new Archive[]{artifactManager.artifact(gav)});
                    }
                } else {
                    Set paths = appEnv.resolveDependencies(Collections.EMPTY_LIST);
                    Iterator iterator = paths.iterator();
                    while (iterator.hasNext()) {
                        String path = (String)iterator.next();
                        depContainer.addAsLibraries(new File[]{new File(path)});
                    }
                }
                depContainer.addMarker("org.wildfly.swarm.allDependencies.added");
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to resolve archive dependencies", t);
            }
        }
        if (!this.archiveMetadataProcessors.isUnsatisfied()) {
            Indexer indexer = new Indexer();
            Map c = deployment.getContent();
            try {
                for (Map.Entry each : c.entrySet()) {
                    if (!((ArchivePath)each.getKey()).get().endsWith(CLASS_SUFFIX)) continue;
                    indexer.index(((Node)each.getValue()).getAsset().openStream());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Index index = indexer.complete();
            for (ArchiveMetadataProcessor processor : this.archiveMetadataProcessors) {
                processor.processArchive(deployment, index);
            }
        }
        for (Object preparer : this.archivePreparers) {
            preparer.prepareArchive(deployment);
        }
        if (this.debug) {
            Map ctx = deployment.getContent();
            for (Object each : ctx.entrySet()) {
                System.err.println(each.getKey() + " // " + each.getValue());
            }
        }
        if (BootstrapProperties.flagIsSet((String)"swarm.export.deployment")) {
            File out = new File(deployment.getName());
            System.err.println("Exporting deployment to " + out.getAbsolutePath());
            ((ZipExporter)deployment.as(ZipExporter.class)).exportTo(out, true);
        }
        VirtualFile mountPoint = VFS.getRootVirtualFile().getChild(deployment.getName());
        try {
            Object each;
            InputStream in = ((ZipExporter)deployment.as(ZipExporter.class)).exportAsInputStream();
            each = null;
            try {
                Closeable closeable = VFS.mountZipExpanded((InputStream)in, (String)deployment.getName(), (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
                this.mountPoints.add(closeable);
            }
            catch (Throwable closeable) {
                each = closeable;
                throw closeable;
            }
            finally {
                if (in != null) {
                    if (each != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable closeable) {
                            ((Throwable)each).addSuppressed(closeable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw SwarmMessages.MESSAGES.failToMountDeployment(e, deployment);
        }
        byte[] hash = this.contentProvider.addContent(mountPoint);
        ModelNode deploymentAdd = new ModelNode();
        deploymentAdd.get("operation").set("add");
        deploymentAdd.get("address").set("deployment", deployment.getName());
        deploymentAdd.get("runtime-name").set(deployment.getName());
        deploymentAdd.get("enabled").set(true);
        int deploymentTimeout = Integer.getInteger("swarm.deployment.timeout", 300);
        ModelNode opHeaders = new ModelNode();
        opHeaders.get("blocking-timeout").set(deploymentTimeout);
        deploymentAdd.get("operation-headers").set(opHeaders);
        ModelNode content = deploymentAdd.get("content").add();
        content.get("hash").set(hash);
        BootstrapLogger.logger((String)"org.wildfly.swarm.runtime.deployer").info((Object)("deploying " + deployment.getName()));
        System.setProperty("swarm.current.deployment", deployment.getName());
        try {
            ModelNode result = this.client.execute(deploymentAdd);
            ModelNode outcome = result.get("outcome");
            if (outcome.asString().equals("success")) {
                return;
            }
            ModelNode description = result.get("failure-description");
            throw new DeploymentException(deployment, SwarmMessages.MESSAGES.deploymentFailed(description.asString()));
        }
        catch (IOException e) {
            throw SwarmMessages.MESSAGES.deploymentFailed(e, deployment);
        }
    }

    @PreDestroy
    void stop() {
        for (Closeable each : this.mountPoints) {
            try {
                each.close();
            }
            catch (IOException iOException) {}
        }
    }
}

