/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.selfcontained.ContentProvider;
import org.jboss.as.server.SelfContainedContainer;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.container.internal.Deployer;
import org.wildfly.swarm.container.internal.Server;
import org.wildfly.swarm.container.runtime.RuntimeDeployer;
import org.wildfly.swarm.container.runtime.deployments.DefaultDeploymentCreator;
import org.wildfly.swarm.container.runtime.marshal.DMRMarshaller;
import org.wildfly.swarm.container.runtime.wildfly.SimpleContentProvider;
import org.wildfly.swarm.container.runtime.wildfly.UUIDFactory;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.StageConfig;
import org.wildfly.swarm.spi.api.UserSpaceExtensionFactory;
import org.wildfly.swarm.spi.runtime.annotations.Post;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Singleton
public class RuntimeServer
implements Server {
    @Inject
    @Pre
    private Instance<Customizer> preCustomizers;
    @Inject
    @Post
    private Instance<Customizer> postCustomizers;
    @Inject
    @Any
    private Instance<ServiceActivator> serviceActivators;
    @Inject
    @Any
    private Instance<Archive> implicitDeployments;
    @Inject
    private DMRMarshaller dmrMarshaller;
    @Inject
    private DefaultDeploymentCreator defaultDeploymentCreator;
    @Inject
    private SimpleContentProvider contentProvider;
    @Inject
    private Instance<RuntimeDeployer> deployer;
    @Inject
    private StageConfig stageConfig;
    @Inject
    @Any
    private Instance<UserSpaceExtensionFactory> userSpaceExtensionFactories;
    private SelfContainedContainer container = new SelfContainedContainer();
    private ServiceContainer serviceContainer;
    private ModelControllerClient client;
    private BootstrapLogger LOG = BootstrapLogger.logger((String)"org.wildfly.swarm.runtime.server");

    public RuntimeServer() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.serviceContainer != null) {
                try {
                    this.LOG.info((Object)"Shutdown requested ...");
                    this.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
    }

    @Produces
    @ApplicationScoped
    ModelControllerClient client() {
        return this.client;
    }

    public Deployer start(boolean eagerOpen) throws Exception {
        UUID uuid = UUIDFactory.getUUID();
        System.setProperty("jboss.server.management.uuid", uuid.toString());
        for (Customizer each : this.preCustomizers) {
            SwarmMessages.MESSAGES.callingPreCustomizer(each);
            each.customize();
        }
        for (Customizer each : this.postCustomizers) {
            SwarmMessages.MESSAGES.callingPostCustomizer(each);
            each.customize();
        }
        ArrayList<ModelNode> bootstrapOperations = new ArrayList<ModelNode>();
        this.dmrMarshaller.marshal(bootstrapOperations);
        SwarmMessages.MESSAGES.wildflyBootstrap(((Object)bootstrapOperations).toString());
        Thread.currentThread().setContextClassLoader(RuntimeServer.class.getClassLoader());
        ArrayList activators = new ArrayList();
        this.serviceActivators.forEach(activators::add);
        this.serviceContainer = this.container.start(bootstrapOperations, (ContentProvider)this.contentProvider, activators);
        for (ServiceName serviceName : this.serviceContainer.getServiceNames()) {
            ServiceController serviceController = this.serviceContainer.getService(serviceName);
            StartException exception = serviceController.getStartException();
            if (exception == null) continue;
            throw exception;
        }
        ModelController controller = (ModelController)this.serviceContainer.getService(Services.JBOSS_SERVER_CONTROLLER).getValue();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.client = controller.createClient((Executor)executor);
        RuntimeDeployer deployer = (RuntimeDeployer)this.deployer.get();
        this.serviceContainer.addService(ServiceName.of((String[])new String[]{"swarm", "deployer"}), (Service)new ValueService((Value)new ImmediateValue((Object)deployer))).install();
        this.configureUserSpaceExtensions();
        for (Archive each : this.implicitDeployments) {
            deployer.deploy(each);
        }
        return deployer;
    }

    private void configureUserSpaceExtensions() {
        this.userSpaceExtensionFactories.forEach(factory -> {
            try {
                factory.configure();
            }
            catch (Exception e) {
                SwarmMessages.MESSAGES.errorInstallingUserSpaceExtension(factory.getClass().getName());
            }
        });
    }

    @Override
    public void stop() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.serviceContainer.addTerminateListener(info -> latch.countDown());
        this.serviceContainer.shutdown();
        latch.await();
        this.serviceContainer = null;
        this.client = null;
        this.deployer = null;
    }

    @Override
    public Deployer deployer() {
        return (Deployer)this.deployer.get();
    }
}

