/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.Vetoed;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.ArtifactLookup;

@Vetoed
public class ArtifactManager
implements ArtifactLookup {
    public JavaArchive artifact(String gav) throws IOException, ModuleLoadException {
        return this.artifact(gav, null);
    }

    public JavaArchive artifact(String gav, String asName) throws IOException, ModuleLoadException {
        File file = this.findFile(gav);
        if (file == null) {
            throw SwarmMessages.MESSAGES.artifactNotFound(gav);
        }
        return (JavaArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)(asName == null ? file.getName() : asName))).importFrom(file)).as(JavaArchive.class);
    }

    public List<JavaArchive> allArtifacts() throws IOException {
        return this.allArtifacts("");
    }

    public List<JavaArchive> allArtifacts(String ... groupIdExclusions) throws IOException {
        HashMap<String, Assignable> archives = new HashMap<String, Assignable>();
        List<String> exclusions = Arrays.asList(groupIdExclusions);
        ApplicationEnvironment env = ApplicationEnvironment.get();
        Set archivesPaths = env.resolveDependencies(exclusions);
        for (String element : archivesPaths) {
            File artifact = new File(element);
            if (artifact.isFile()) {
                archives.put(artifact.getName(), ((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)artifact.getName())).importFrom(artifact)).as(JavaArchive.class));
                continue;
            }
            String archiveName = FileSystemLayout.archiveNameForClassesDir(artifact.toPath());
            if (archives.containsKey(archiveName)) {
                ((ExplodedImporter)((JavaArchive)archives.get(archiveName)).as(ExplodedImporter.class)).importDirectory(artifact);
                continue;
            }
            archives.put(archiveName, ((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)archiveName)).importDirectory(artifact).as(JavaArchive.class));
        }
        return new ArrayList<JavaArchive>(archives.values());
    }

    private File findFile(String gav) throws IOException, ModuleLoadException {
        String[] parts = gav.split(":");
        if (parts.length < 2) {
            throw SwarmMessages.MESSAGES.gavMinimumSegments();
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String packaging = "jar";
        String version = null;
        String classifier = "";
        if (parts.length == 3) {
            version = parts[2];
        }
        if (parts.length == 4) {
            packaging = parts[2];
            version = parts[3];
        }
        if (parts.length == 5) {
            packaging = parts[2];
            version = parts[3];
            classifier = parts[4];
        }
        if (version != null && (version.isEmpty() || version.equals("*"))) {
            version = null;
        }
        if (version == null) {
            version = this.determineVersionViaApplicationEnvironment(groupId, artifactId, packaging, classifier);
        }
        if (version == null) {
            version = this.determineVersionViaClasspath(groupId, artifactId, packaging, classifier);
        }
        if (version == null) {
            throw SwarmMessages.MESSAGES.unableToDetermineVersion(gav);
        }
        ArtifactCoordinates coords = new ArtifactCoordinates(groupId, artifactId, version, classifier == null ? "" : classifier);
        return MavenResolvers.get().resolveArtifact(coords, packaging);
    }

    String determineVersionViaApplicationEnvironment(String groupId, String artifactId, String packaging, String classifier) throws IOException {
        ApplicationEnvironment env = ApplicationEnvironment.get();
        if (classifier.isEmpty()) {
            classifier = null;
        }
        for (String dep : env.getDependencies()) {
            String[] parts = dep.split(":");
            String depGroupId = parts[0];
            String depArtifactId = parts[1];
            String depPackaging = parts[2];
            String depVersion = null;
            String depClassifier = null;
            if (parts.length == 4) {
                depVersion = parts[3];
            } else {
                depClassifier = parts[3];
                depVersion = parts[4];
            }
            if (!groupId.equals(depGroupId) || !artifactId.equals(depArtifactId) || !packaging.equals(depPackaging) || !(classifier == null ? depClassifier == null : depClassifier != null && classifier.equals(depClassifier))) continue;
            return depVersion;
        }
        return null;
    }

    private String determineVersionViaClasspath(String groupId, String artifactId, String packaging, String classifier) {
        String regexp = ".*" + artifactId + "-(.+)" + (classifier.length() == 0 ? "" : "-" + classifier) + "." + packaging;
        Pattern pattern = Pattern.compile(regexp);
        for (String element : System.getProperty("java.class.path").split(File.pathSeparator)) {
            Matcher matcher = pattern.matcher(element);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

