/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.container.DeploymentException;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;

@MessageLogger(projectCode="WFSWARM", length=4)
public interface SwarmMessages
extends BasicLogger {
    public static final SwarmMessages MESSAGES = (SwarmMessages)Logger.getMessageLogger(SwarmMessages.class, (String)"org.wildfly.swarm");

    @Message(id=1, value="Stage config is not present.")
    public RuntimeException missingStageConfig();

    @Message(id=2, value="Cannot invoke %s on a container that has not been started.")
    public IllegalStateException containerNotStarted(String var1);

    @Message(id=3, value="Project stage '%s' cannot be found.")
    public RuntimeException stageNotFound(String var1);

    @Message(id=4, value="%s requires an argument.")
    public RuntimeException argumentRequired(String var1);

    @Message(id=5, value="Unable to create default deployment")
    public DeploymentException cannotCreateDefaultDeployment();

    @Message(id=6, value="Failed to mount deployment.")
    public DeploymentException failToMountDeployment(@Cause Throwable var1, @Param Archive<?> var2);

    @Message(id=7, value="Deployment failed: %s")
    public String deploymentFailed(String var1);

    @Message(id=8, value="Failure during deployment")
    public DeploymentException deploymentFailed(@Cause Throwable var1, @Param Archive<?> var2);

    @Message(id=9, value="JavaArchive spec does not support Libraries")
    public UnsupportedOperationException librariesNotSupported();

    @Message(id=10, value="Failed to load stage configuration from URL : %s")
    public RuntimeException failedLoadingStageConfig(@Cause Throwable var1, URL var2);

    @Message(id=11, value="Missing stage 'default' in project-stages.yml")
    public RuntimeException missingDefaultStage();

    @Message(id=12, value="Fraction \"%s\" was configured using @WildFlyExtension with a module='', but has multiple extension classes.  Please use classname='' to specify exactly one, or noClass=true to ignore all. %s")
    public RuntimeException fractionHasMultipleExtensions(String var1, Collection<String> var2);

    @Message(id=13, value="Artifact '%s' not found.")
    public RuntimeException artifactNotFound(String var1);

    @Message(id=14, value="Unable to determine version number from GAV: %s")
    public RuntimeException unableToDetermineVersion(String var1);

    @Message(id=15, value="GAV must includes at least 2 segments")
    public RuntimeException gavMinimumSegments();

    @Message(id=16, value="System property '%s' not provided.")
    public IllegalStateException systemPropertyNotFound(String var1);

    @Message(id=17, value="Cannot identify FileSystemLayout for given path: %s")
    public IllegalArgumentException cannotIdentifyFileSystemLayout(String var1);

    @Message(id=18, value="Installed fraction: %24s - %-15s %s:%s:%s")
    public String availableFraction(String var1, String var2, String var3, String var4, String var5);

    @Message(id=19, value="No deployments specified on the command-line")
    public String noDeploymentsSpecified();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=20, value="Stage Config found in %s at location: %s")
    public void stageConfigLocation(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=21, value="Failed to parse project stage URL reference, ignoring: %s")
    public void malformedStageConfigUrl(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22, value="Project stage superseded by external configuration %s")
    public void stageConfigSuperseded(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=23, value="Unable to setup Shrinkwrap Domain")
    public void shrinkwrapDomainSetupFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=24, value="Using project stage: %s")
    public void usingProjectStage(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=25, value="Add deployment module: %s")
    public void deploymentModuleAdded(DeploymentModule var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=26, value="Calling Pre Customizer: %s")
    public void callingPreCustomizer(Customizer var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=27, value="Calling Post Customizer: %s")
    public void callingPostCustomizer(Customizer var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=28, value="WildFly Bootstrap operations: \n %s")
    public void wildflyBootstrap(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="Install MSC service for command line args: %s")
    public void argsInstalled(List<String> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=30, value="Marshalling Project Stage property %s")
    public void marshalProjectStageProperty(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=31, value="Marshalling XML from %s as: \n %s")
    public void marshalXml(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=32, value="Load standalone.xml via %s from %s")
    public void loadingStandaloneXml(String var1, String var2);

    @Message(id=33, value="HTTP/S is configured correctly, but org.wildfly.swarm:management is not available")
    public RuntimeException httpsRequiresManagementFraction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=34, value="Ignoring subsystem %s:%s")
    public void ignoringSubsystem(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=35, value="Failed to register modules mbeans")
    public void moduleMBeanServerNotInstalled(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=36, value="Error installing user-space CDI extension: %s")
    public void errorInstallingUserSpaceExtension(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=99999, value="WildFly Swarm is Ready")
    public void wildflySwarmIsReady();
}

