/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.weld.literal.AnyLiteral;
import org.wildfly.swarm.container.runtime.ConfigurableManager;
import org.wildfly.swarm.container.runtime.cdi.configurable.ConfigurableFractionBean;
import org.wildfly.swarm.spi.api.Fraction;

public class FractionProducingExtension
implements Extension {
    private final Set<Class<? extends Fraction>> fractionClasses = new HashSet<Class<? extends Fraction>>();
    private final List<Fraction> explicitlyInstalledFractions = new ArrayList<Fraction>();
    private final ConfigurableManager configurableManager;

    public FractionProducingExtension(Collection<Fraction> explicitlyInstalled, ConfigurableManager configurableManager) {
        this.explicitlyInstalledFractions.addAll(explicitlyInstalled);
        this.configurableManager = configurableManager;
    }

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<? extends Fraction> pat) {
        Class cls = pat.getAnnotatedType().getJavaClass();
        if (Fraction.class.isAssignableFrom(cls)) {
            pat.veto();
            if (cls == Fraction.class) {
                return;
            }
            this.fractionClasses.add(cls);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        HashSet preExistingFractionClasses = new HashSet();
        for (Fraction fraction : this.explicitlyInstalledFractions) {
            try {
                abd.addBean(new ConfigurableFractionBean<Fraction>(fraction, this.configurableManager));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                throw new RuntimeException(e2);
            }
            preExistingFractionClasses.add(fraction.getClass());
        }
        Set availableFractionBeans = beanManager.getBeans(Fraction.class, new Annotation[]{AnyLiteral.INSTANCE});
        preExistingFractionClasses.addAll(availableFractionBeans.stream().flatMap(e -> e.getTypes().stream()).collect(Collectors.toSet()));
        this.fractionClasses.stream().filter(cls -> !preExistingFractionClasses.contains(cls)).forEach(cls -> {
            try {
                abd.addBean(new ConfigurableFractionBean(cls, this.configurableManager));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

