/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.logging;

import javax.enterprise.inject.Vetoed;
import org.jboss.logging.Logger;
import org.wildfly.swarm.bootstrap.logging.BackingLogger;

@Vetoed
public class JBossLoggingLogger
implements BackingLogger {
    private final Logger logger;

    public JBossLoggingLogger(Logger logger) {
        this.logger = logger;
    }

    public Object getLevel() {
        if (this.logger.isEnabled(Logger.Level.TRACE)) {
            return "TRACE";
        }
        if (this.logger.isEnabled(Logger.Level.DEBUG)) {
            return "DEBUG";
        }
        if (this.logger.isEnabled(Logger.Level.INFO)) {
            return "INFO";
        }
        if (this.logger.isEnabled(Logger.Level.WARN)) {
            return "WARN";
        }
        if (this.logger.isEnabled(Logger.Level.ERROR)) {
            return "ERROR";
        }
        return "UNKNOWN";
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(Object message) {
        this.logger.trace(message);
    }

    public void debug(Object message) {
        this.logger.debug(message);
    }

    public void info(Object message) {
        this.logger.info(message);
    }

    public void warn(Object message) {
        this.logger.warn(message);
    }

    public void error(Object message) {
        this.logger.error(message);
    }

    public void error(Object message, Throwable t) {
        this.logger.error(message, t);
    }
}

