/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.marshal;

import java.net.URL;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.container.runtime.marshal.ConfigurationMarshaller;
import org.wildfly.swarm.container.runtime.xmlconfig.StandaloneXMLParser;
import org.wildfly.swarm.container.runtime.xmlconfig.XMLConfig;

@ApplicationScoped
public class XMLMarshaller
implements ConfigurationMarshaller {
    @Inject
    @XMLConfig
    private Instance<URL> xmlConfig;
    @Inject
    private StandaloneXMLParser parser;

    @Override
    public void marshal(List<ModelNode> list) {
        if (this.xmlConfig.isUnsatisfied()) {
            return;
        }
        this.xmlConfig.forEach(url -> this.parse((URL)url, list));
    }

    protected void parse(URL url, List<ModelNode> list) {
        if (url == null) {
            return;
        }
        try {
            List<ModelNode> subList = this.parser.parse(url);
            list.addAll(subList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

