/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmDependenciesConf;
import org.wildfly.swarm.internal.DependencyResolution;

@Vetoed
public class MavenDependencyResolution
implements DependencyResolution {
    private final WildFlySwarmDependenciesConf deps;

    public MavenDependencyResolution(WildFlySwarmDependenciesConf deps) {
        this.deps = deps;
    }

    @Override
    public Set<String> resolve(List<String> exclusions) throws IOException {
        HashSet<String> archivePaths = new HashSet<String>();
        for (MavenArtifactDescriptor each : this.deps.getPrimaryDependencies()) {
            if (exclusions.contains(each.groupId())) continue;
            File artifact = MavenResolvers.get().resolveJarArtifact(each.mscCoordinates());
            archivePaths.add(artifact.getAbsolutePath());
        }
        return archivePaths;
    }
}

