/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.enterprise.inject.Vetoed;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmClasspathConf;
import org.wildfly.swarm.internal.DependencyResolution;

@Vetoed
public class SystemDependencyResolution
implements DependencyResolution {
    private static final String JAR = ".jar";
    private static final String JRE = "jre";
    final List<String> classpath;
    final String javaHome;
    final String pwd;
    final List<String> testClasspath;

    public SystemDependencyResolution() {
        String classpathProp = System.getProperty("java.class.path");
        String javaHomProp = System.getProperty("java.home");
        String userDirProp = System.getProperty("user.dir");
        String testClasspatProp = System.getProperty("swarm.test.dependencies");
        this.classpath = Arrays.asList(classpathProp.split(File.pathSeparator));
        this.testClasspath = testClasspatProp != null ? Arrays.asList(testClasspatProp.split(File.pathSeparator)) : Collections.EMPTY_LIST;
        this.pwd = userDirProp;
        this.javaHome = javaHomProp.endsWith(JRE) ? javaHomProp.substring(0, javaHomProp.lastIndexOf(JRE)) : javaHomProp;
    }

    SystemDependencyResolution(List<String> classpath, String javaHome, String pwd, List<String> testClasspath) {
        this.classpath = classpath;
        this.pwd = pwd;
        this.javaHome = javaHome.endsWith(JRE) ? javaHome.substring(0, javaHome.lastIndexOf(JRE)) : javaHome;
        this.testClasspath = testClasspath;
    }

    @Override
    public Set<String> resolve(List<String> exclusions) throws IOException {
        HashSet<String> archivesPaths = new HashSet<String>();
        exclusions.replaceAll(s -> s.replace('.', File.separatorChar));
        if (this.classpath != null) {
            WildFlySwarmClasspathConf classpathConf = new WildFlySwarmClasspathConf();
            HashSet<String> classpathElements = new HashSet<String>();
            HashSet<String> providedGAVs = new HashSet<String>();
            List<String> testClasspathElements = this.testClasspath != null ? this.testClasspath : Collections.EMPTY_LIST;
            for (String element : this.classpath) {
                if (element.startsWith(this.javaHome) || element.startsWith(this.pwd + File.separatorChar) || element.endsWith(".pom")) continue;
                if (element.endsWith(JAR)) {
                    try (JarFile jar = new JarFile(new File(element));){
                        ZipEntry entry = jar.getEntry("META-INF/wildfly-swarm-classpath.conf");
                        if (entry != null) {
                            classpathConf.read(jar.getInputStream(entry));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.excluded(exclusions, element)) continue;
                classpathElements.add(element);
            }
            providedGAVs.addAll(classpathConf.getMatchesForActionType(WildFlySwarmClasspathConf.MavenMatcher.class, WildFlySwarmClasspathConf.RemoveAction.class).stream().map(m -> (WildFlySwarmClasspathConf.MavenMatcher)m).map(m -> m.groupId + "." + m.artifactId).map(m -> m.replace('.', File.separatorChar)).collect(Collectors.toList()));
            for (String element : classpathElements) {
                if (this.excluded(providedGAVs, element) || this.excluded(testClasspathElements, element)) continue;
                archivesPaths.add(element);
            }
        }
        return archivesPaths;
    }
}

