/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.wildfly.swarm.spi.api.StageConfig;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;

@Singleton
public class ConfigurationValueProducer {
    @Inject
    private StageConfig stageConfig;

    @Produces
    @ConfigurationValue(value="")
    @Dependent
    StageConfig.Resolver<String> produceResolver(InjectionPoint injectionPoint) {
        return this.resolver(injectionPoint);
    }

    @Produces
    @ConfigurationValue(value="")
    @Dependent
    String produceStringConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, String.class);
    }

    @Produces
    @ConfigurationValue(value="")
    @Dependent
    Integer produceIntegerConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Integer.class);
    }

    @Produces
    @Dependent
    @ConfigurationValue(value="")
    Boolean produceBooleanConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Boolean.class);
    }

    @ConfigurationValue(value="")
    @Dependent
    @Produces
    Long produceLongConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Long.class);
    }

    @ConfigurationValue(value="")
    @Dependent
    @Produces
    Float produceFloatConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Float.class);
    }

    @ConfigurationValue(value="")
    @Dependent
    @Produces
    Double produceDoubleConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Double.class);
    }

    private <T> T resolve(InjectionPoint injectionPoint, Class<T> target) {
        StageConfig.Resolver<String> resolver = this.resolver(injectionPoint);
        try {
            return (T)(resolver != null ? resolver.as(target).getValue() : null);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private StageConfig.Resolver<String> resolver(InjectionPoint injectionPoint) {
        String name = this.getName(injectionPoint);
        if (name == null || name.isEmpty() || this.stageConfig == null) {
            return null;
        }
        return this.stageConfig.resolve(this.getName(injectionPoint));
    }

    private String getName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigurationValue.class)) continue;
            return ((ConfigurationValue)qualifier).value();
        }
        return null;
    }
}

