/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;
import org.wildfly.swarm.spi.api.Fraction;

public class FractionProducingExtension
implements Extension {
    private Set<Class<? extends Fraction>> fractionClasses = new HashSet<Class<? extends Fraction>>();
    private List<Fraction> explicitlyInstalledFractions = new ArrayList<Fraction>();

    public FractionProducingExtension(Collection<Fraction> explicitlyInstalled) {
        this.explicitlyInstalledFractions.addAll(explicitlyInstalled);
    }

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<? extends Fraction> pat) {
        Class cls = pat.getAnnotatedType().getJavaClass();
        if (Fraction.class.isAssignableFrom(cls)) {
            pat.veto();
            if (cls == Fraction.class) {
                return;
            }
            this.fractionClasses.add(cls);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        HashSet preExistingFractionClasses = new HashSet();
        for (Fraction fraction : this.explicitlyInstalledFractions) {
            abd.addBean().addTypes(this.applicableClasses(fraction.getClass())).scope(Singleton.class).addQualifier((Annotation)new AnnotationLiteral<Default>(){}).produceWith(() -> fraction);
            preExistingFractionClasses.add(fraction.getClass());
        }
        Set availableFractionBeans = beanManager.getBeans(Fraction.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        preExistingFractionClasses.addAll(availableFractionBeans.stream().flatMap(e -> e.getTypes().stream()).collect(Collectors.toSet()));
        this.fractionClasses.stream().filter(cls -> !preExistingFractionClasses.contains(cls)).forEach(cls -> abd.addBean().addTypes(this.applicableClasses((Class)cls)).scope(Singleton.class).addQualifier((Annotation)new AnnotationLiteral<Default>(){}).produceWith(() -> {
            try {
                return ((Fraction)cls.newInstance()).applyDefaults();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    Set<Type> applicableClasses(Class cur) {
        HashSet<Type> classes = new HashSet<Type>();
        this.applicableClasses(cur, classes);
        return classes;
    }

    void applicableClasses(Class cur, Set<Type> set) {
        if (cur == null) {
            return;
        }
        set.add(cur);
        for (Class<?> each : cur.getInterfaces()) {
            this.applicableClasses(each, set);
        }
        this.applicableClasses(cur.getSuperclass(), set);
    }
}

