/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.deployments;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.wildfly.swarm.spi.api.DefaultDeploymentFactory;
import org.wildfly.swarm.spi.api.JARArchive;

@ApplicationScoped
public class DefaultDeploymentCreator {
    private Map<String, DefaultDeploymentFactory> factories = new HashMap<String, DefaultDeploymentFactory>();

    @Inject
    public DefaultDeploymentCreator(@Any Instance<DefaultDeploymentFactory> factories) {
        this((Iterable<DefaultDeploymentFactory>)factories);
    }

    public DefaultDeploymentCreator(DefaultDeploymentFactory ... factories) {
        this(Arrays.asList(factories));
    }

    public DefaultDeploymentCreator(Iterable<DefaultDeploymentFactory> factories) {
        for (DefaultDeploymentFactory factory : factories) {
            DefaultDeploymentFactory current = this.factories.get(factory.getType());
            if (current == null) {
                this.factories.put(factory.getType(), factory);
                continue;
            }
            if (factory.getPriority() <= current.getPriority()) continue;
            this.factories.put(factory.getType(), factory);
        }
    }

    public Archive<?> createDefaultDeployment(String type) {
        try {
            return this.getFactory(type).create();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    DefaultDeploymentFactory getFactory(String type) {
        DefaultDeploymentFactory factory = this.factories.get(type);
        if (factory != null) {
            return factory;
        }
        return new EmptyJARArchiveDeploymentFactory(type);
    }

    private static class EmptyJARArchiveDeploymentFactory
    extends DefaultDeploymentFactory {
        private final String type;

        public EmptyJARArchiveDeploymentFactory(String type) {
            this.type = type;
        }

        public int getPriority() {
            return 0;
        }

        public String getType() {
            return this.type;
        }

        public Archive create() throws Exception {
            return (Archive)ShrinkWrap.create(JARArchive.class, (String)(UUID.randomUUID().toString() + "." + this.type));
        }

        protected boolean setupUsingMaven(Archive<?> archive) throws Exception {
            return false;
        }
    }
}

