/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.cdi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import org.wildfly.swarm.container.cdi.ProjectStageImpl;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.ProjectStage;
import org.yaml.snakeyaml.Yaml;

@Vetoed
public class ProjectStageFactory {
    private static final String PROJECT_PREFIX = "project";
    private static final String STAGE = "stage";
    private static final String DEFAULT = "default";

    public List<ProjectStage> loadStages(URL url) {
        try {
            return this.loadStages(url.openStream());
        }
        catch (IOException e) {
            throw SwarmMessages.MESSAGES.failedLoadingStageConfig(e, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProjectStage> loadStages(InputStream inputStream) {
        try {
            LinkedList<ProjectStage> stages = new LinkedList<ProjectStage>();
            Yaml yaml = new Yaml();
            Iterable docs = yaml.loadAll(inputStream);
            for (Object item : docs) {
                Map doc = (Map)item;
                String stageName = doc.get(PROJECT_PREFIX) != null ? (String)((Map)doc.get(PROJECT_PREFIX)).get(STAGE) : DEFAULT;
                ProjectStageImpl stage2 = new ProjectStageImpl(stageName);
                for (String key : doc.keySet()) {
                    if (key.equals(PROJECT_PREFIX)) continue;
                    stage2.getConfig().put(key, doc.get(key));
                }
                stages.add(stage2.initialize());
            }
            Optional<ProjectStage> defaultStage = stages.stream().filter(stage -> DEFAULT.equals(stage.getName())).findFirst();
            if (!defaultStage.isPresent()) {
                throw SwarmMessages.MESSAGES.missingDefaultStage();
            }
            Map defaults = defaultStage.get().getProperties();
            stages.stream().filter(stage -> !stage.getName().equals(DEFAULT)).forEach(stage -> {
                Map current = stage.getProperties();
                Set currentKeys = current.keySet();
                defaults.keySet().forEach(key -> {
                    if (!currentKeys.contains(key)) {
                        current.put(key, defaults.get(key));
                    }
                });
            });
            LinkedList<ProjectStage> linkedList = stages;
            return linkedList;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

