/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.container.runtime.ConfigurableHandle;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.StageConfig;
import org.wildfly.swarm.spi.api.annotations.Configurable;

public class ConfigurableManager
implements AutoCloseable {
    private static final Set<String> BLACKLISTED_FIELDS = new HashSet<String>(){
        {
            this.add("pcs");
            this.add("key");
            this.add("subresources");
        }
    };
    private static final Set<Class<?>> BLACKLISTED_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(Map.class);
            this.add(Properties.class);
        }
    };
    private static final Set<Class<?>> CONFIGURABLE_VALUE_TYPES = new HashSet<Class<?>>(){
        {
            this.add(Boolean.class);
            this.add(Boolean.TYPE);
            this.add(Short.class);
            this.add(Short.TYPE);
            this.add(Integer.class);
            this.add(Integer.TYPE);
            this.add(Long.class);
            this.add(Long.TYPE);
            this.add(Float.class);
            this.add(Float.TYPE);
            this.add(String.class);
            this.add(Map.class);
            this.add(Properties.class);
            this.add(Defaultable.class);
        }
    };
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.config");
    private final List<ConfigurableHandle> configurables = new ArrayList<ConfigurableHandle>();
    private final StageConfig stageConfig;

    public ConfigurableManager(StageConfig stageConfig) {
        this.stageConfig = stageConfig;
    }

    public List<ConfigurableHandle> configurables() {
        return this.configurables;
    }

    protected <T> void configure(ConfigurableHandle configurable) throws IllegalAccessException {
        StageConfig.Resolver<Properties> resolver = this.stageConfig.resolve(configurable.name());
        Class<?> resolvedType = configurable.type();
        boolean isMap = false;
        boolean isProperties = false;
        if (resolvedType.isEnum()) {
            resolver = resolver.as(resolvedType, this.converter(resolvedType));
        } else if (Map.class.isAssignableFrom(resolvedType)) {
            isMap = true;
            resolver = this.mapResolver((StageConfig.Resolver<String>)resolver, configurable.name());
        } else if (Properties.class.isAssignableFrom(resolvedType)) {
            isProperties = true;
            resolver = this.propertiesResolver((StageConfig.Resolver<String>)resolver, configurable.name());
        } else {
            resolver = resolver.as(configurable.type());
        }
        if (isMap || isProperties || resolver.hasValue()) {
            Object resolvedValue = resolver.getValue();
            if (!(isMap && ((Map)resolvedValue).isEmpty() || isProperties && ((Properties)resolvedValue).isEmpty())) {
                configurable.set(configurable.type().cast(resolvedValue));
            }
        }
    }

    private <ENUMTYPE extends Enum<ENUMTYPE>> StageConfig.Converter<ENUMTYPE> converter(Class<ENUMTYPE> enumType) {
        return str -> Enum.valueOf(enumType, str.toUpperCase().replace('-', '_'));
    }

    private StageConfig.Resolver<Map> mapResolver(StageConfig.Resolver<String> resolver, String name) {
        return resolver.withDefault((Object)"").as(Map.class, this.mapConverter(name));
    }

    private StageConfig.Converter<Map> mapConverter(String name) {
        return ignored -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Set subKeys = this.stageConfig.simpleSubkeys(name);
            for (String subKey : subKeys) {
                map.put(subKey, this.stageConfig.resolve(name + '.' + subKey).getValue());
            }
            return map;
        };
    }

    private StageConfig.Resolver<Properties> propertiesResolver(StageConfig.Resolver<String> resolver, String name) {
        return resolver.withDefault((Object)"").as(Properties.class, this.propertiesConverter(name));
    }

    private StageConfig.Converter<Properties> propertiesConverter(String name) {
        return ignored -> {
            Properties props = new Properties();
            Set subKeys = this.stageConfig.simpleSubkeys(name);
            for (String subKey : subKeys) {
                props.setProperty(subKey, (String)this.stageConfig.resolve(name + '.' + subKey).getValue());
            }
            return props;
        };
    }

    public void scan(Object instance) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (instance instanceof Fraction) {
            this.scanFraction((Fraction)instance);
        } else {
            this.scan(null, instance, false);
        }
    }

    protected void scanFraction(Fraction fraction) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String prefix = this.nameFor(fraction);
        this.scan(prefix, fraction, true);
    }

    protected String getKey(Object object) throws InvocationTargetException, IllegalAccessException {
        Object key;
        if (object instanceof Keyed) {
            return ((Keyed)object).getKey();
        }
        Method getKey = this.findGetKeyMethod(object);
        if (getKey != null && (key = getKey.invoke(object, new Object[0])) != null) {
            return key.toString();
        }
        return null;
    }

    protected Method findGetKeyMethod(Object object) {
        Method[] methods;
        for (Method method : methods = object.getClass().getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || !method.getName().equals("getKey") || method.getParameterCount() != 0) continue;
            return method;
        }
        return null;
    }

    protected String nameFor(Fraction fraction) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Configurable anno = fraction.getClass().getAnnotation(Configurable.class);
        if (anno != null) {
            return anno.value();
        }
        String key = this.getKey(fraction);
        if (key == null) {
            key = fraction.getClass().getSimpleName().replace("Fraction", "").toLowerCase();
        }
        return "swarm." + key;
    }

    protected void scan(String prefix, Object instance, boolean isFraction) throws IllegalAccessException, InvocationTargetException {
        this.scan(prefix, instance, instance.getClass(), isFraction);
        if (isFraction) {
            this.scanSubresources(prefix, instance);
        }
    }

    protected void scan(String prefix, Object instance, Class<?> curClass, boolean isFraction) throws IllegalAccessException {
        Field[] fields;
        if (curClass == null || curClass == Object.class || this.isBlacklisted(curClass)) {
            return;
        }
        for (Field field : fields = curClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || this.isBlacklisted(field) || !isFraction && field.getAnnotation(Configurable.class) == null || !this.isConfigurableType(field.getType())) continue;
            ConfigurableHandle configurable = new ConfigurableHandle(this.nameFor(prefix, field), instance, field);
            this.configurables.add(configurable);
            this.configure(configurable);
        }
        this.scan(prefix, instance, curClass.getSuperclass(), isFraction);
    }

    private boolean isConfigurableType(Class<?> type) {
        return type.isEnum() || CONFIGURABLE_VALUE_TYPES.contains(type);
    }

    private boolean isBlacklisted(Class<?> cls) {
        return BLACKLISTED_CLASSES.stream().anyMatch(e -> {
            if (e.isInterface()) {
                for (Class<?> each : cls.getInterfaces()) {
                    if (each != e) continue;
                    return true;
                }
                return false;
            }
            return e == cls;
        });
    }

    private boolean isBlacklisted(Field field) {
        if (BLACKLISTED_FIELDS.stream().anyMatch(e -> e.equals(field.getName()))) {
            return true;
        }
        return this.isBlacklisted(field.getType());
    }

    protected String nameFor(String prefix, Field field) {
        Configurable anno = field.getAnnotation(Configurable.class);
        if (anno != null) {
            if (!anno.value().equals("")) {
                return anno.value();
            }
            if (!anno.simpleName().equals("")) {
                return prefix + "." + anno.simpleName();
            }
        }
        return prefix + "." + this.nameFor(field);
    }

    protected String nameFor(Field field) {
        char[] chars;
        StringBuilder str = new StringBuilder();
        for (char c : chars = field.getName().toCharArray()) {
            if (Character.isUpperCase(c)) {
                str.append("-");
            }
            str.append(Character.toLowerCase(c));
        }
        return str.toString();
    }

    protected void scanSubresources(String prefix, Object instance) throws InvocationTargetException, IllegalAccessException {
        Field[] fields;
        Method method = this.getSubresourcesMethod(instance);
        if (method == null) {
            return;
        }
        Object subresources = method.invoke(instance, new Object[0]);
        for (Field field : fields = subresources.getClass().getDeclaredFields()) {
            if (field.getAnnotation(SubresourceInfo.class) == null && List.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            Object value = field.get(subresources);
            String subPrefix = prefix + "." + this.nameFor(field);
            if (value != null && value instanceof List) {
                Method factoryMethod;
                int index = 0;
                HashSet<String> seenKeys = new HashSet<String>();
                for (Object each : (List)value) {
                    String key = this.getKey(each);
                    String itemPrefix = null;
                    if (key != null) {
                        seenKeys.add(key);
                        itemPrefix = subPrefix + "." + key;
                    } else {
                        itemPrefix = subPrefix + "." + index;
                    }
                    this.scan(itemPrefix, each, true);
                    ++index;
                }
                Set keysWithConfiguration = this.stageConfig.simpleSubkeys(subPrefix);
                keysWithConfiguration.removeAll(seenKeys);
                if (keysWithConfiguration.isEmpty() || (factoryMethod = this.getKeyedFactoryMethod(instance, field)) == null) continue;
                for (String key : keysWithConfiguration) {
                    String itemPrefix = subPrefix + "." + key;
                    Object lambda = this.createLambda(itemPrefix, factoryMethod);
                    if (lambda == null) continue;
                    factoryMethod.invoke(instance, key, lambda);
                }
                continue;
            }
            if (value == null) {
                Object lambda;
                Method factoryMethod;
                if (!this.stageConfig.hasKeyOrSubkeys(subPrefix) || (factoryMethod = this.getNonKeyedFactoryMethod(instance, field)) == null || (lambda = this.createLambda(subPrefix, factoryMethod)) == null) continue;
                factoryMethod.invoke(instance, lambda);
                continue;
            }
            this.scan(subPrefix, value, true);
        }
    }

    protected Object createLambda(String itemPrefix, Method factoryMethod) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> consumerType = factoryMethod.getParameterTypes()[factoryMethod.getParameterCount() - 1];
        try {
            Method acceptMethod = null;
            for (Method method : consumerType.getMethods()) {
                if (!method.getName().equals("accept")) continue;
                acceptMethod = method;
            }
            if (acceptMethod == null) {
                return null;
            }
            MethodHandle target = lookup.findVirtual(ConfigurableManager.class, "subresourceAdded", MethodType.methodType(Void.TYPE, String.class, Object.class));
            MethodType samType = MethodType.methodType(Void.TYPE, acceptMethod.getParameterTypes()[0]);
            MethodHandle mh = LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(consumerType, ConfigurableManager.class, String.class), samType, target, samType).getTarget();
            return mh.invoke(this, itemPrefix);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void subresourceAdded(String itemPrefix, Object object) throws InvocationTargetException, IllegalAccessException {
        this.scan(itemPrefix, object, true);
    }

    protected Method getKeyedFactoryMethod(Object instance, Field field) {
        SubresourceInfo anno = field.getAnnotation(SubresourceInfo.class);
        if (anno != null) {
            Method[] methods;
            String name = anno.value();
            for (Method method : methods = instance.getClass().getMethods()) {
                if (!method.getName().equals(name) || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 2 || method.getParameterTypes()[0] != String.class || method.getParameterTypes()[1].getAnnotation(FunctionalInterface.class) == null) continue;
                boolean acceptMethodFound = false;
                for (Method paramMethod : method.getParameterTypes()[1].getMethods()) {
                    if (!paramMethod.getName().equals("accept")) continue;
                    acceptMethodFound = true;
                    break;
                }
                if (!acceptMethodFound) continue;
                return method;
            }
        }
        return null;
    }

    protected Method getNonKeyedFactoryMethod(Object instance, Field field) {
        Method[] methods;
        String name = field.getName();
        for (Method method : methods = instance.getClass().getMethods()) {
            if (!method.getName().equals(name) || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 1 || method.getParameterTypes()[0].getAnnotation(FunctionalInterface.class) == null) continue;
            boolean acceptMethodFound = false;
            for (Method paramMethod : method.getParameterTypes()[0].getMethods()) {
                if (!paramMethod.getName().equals("accept")) continue;
                acceptMethodFound = true;
                break;
            }
            if (!acceptMethodFound) continue;
            return method;
        }
        return null;
    }

    protected Method getSubresourcesMethod(Object instance) {
        Method[] methods;
        for (Method method : methods = instance.getClass().getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.getName().equals("subresources") || method.getParameterCount() != 0) continue;
            return method;
        }
        return null;
    }

    public void log() {
        boolean verbose = true;
        int longestKey = 0;
        for (ConfigurableHandle each : this.configurables) {
            if (each.name().length() <= longestKey) continue;
            longestKey = each.name().length();
        }
        StringBuilder str = new StringBuilder();
        List sorted = this.configurables.stream().sorted((l, r) -> l.name().compareTo(r.name())).collect(Collectors.toList());
        boolean first = true;
        for (ConfigurableHandle each : sorted) {
            try {
                String name = each.name();
                Object value = each.currentValue();
                if (value == null && !verbose) continue;
                String printedValue = "(unset)";
                if (value != null) {
                    printedValue = name.toLowerCase().contains("password") ? "<redacted>" : value.toString();
                }
                if (!first) {
                    str.append("\n");
                }
                str.append(String.format("  %-" + longestKey + "s = %s", name, printedValue));
                first = false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        SwarmMessages.MESSAGES.configuration(str.toString());
    }

    @Override
    public void close() {
        this.configurables.clear();
    }
}

