/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.xmlconfig;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.namespace.QName;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.staxmapper.XMLElementReader;
import org.wildfly.swarm.container.runtime.xmlconfig.StandaloneXMLParser;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@Singleton
public class StandaloneXMLParserProducer {
    @Inject
    private Instance<Fraction> fractions;
    private StandaloneXMLParser parser = new StandaloneXMLParser();

    @PostConstruct
    public void setupFactories() {
        this.fractions.forEach(this::setupFactory);
    }

    @Produces
    @Singleton
    StandaloneXMLParser standaloneXmlParser() {
        return this.parser;
    }

    private void setupFactory(Fraction fraction) {
        WildFlyExtension anno = fraction.getClass().getAnnotation(WildFlyExtension.class);
        if (anno == null) {
            return;
        }
        String extensionModuleName = anno.module();
        String extensionClassName = anno.classname();
        boolean noClass = anno.noClass();
        if (extensionClassName != null && extensionClassName.trim().isEmpty()) {
            extensionClassName = null;
        }
        try {
            Module extensionModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)extensionModuleName));
            if (!noClass) {
                if (extensionClassName != null) {
                    Class extCls = extensionModule.getClassLoader().loadClass(extensionClassName);
                    try {
                        Extension ext = (Extension)extCls.newInstance();
                        this.add(ext);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                } else {
                    ServiceLoader extensionLoader = extensionModule.loadService(Extension.class);
                    Iterator extensionIter = extensionLoader.iterator();
                    ArrayList<Extension> extensions = new ArrayList<Extension>();
                    if (extensionIter.hasNext()) {
                        Extension ext = (Extension)extensionIter.next();
                        extensions.add(ext);
                    }
                    if (extensions.size() > 1) {
                        throw SwarmMessages.MESSAGES.fractionHasMultipleExtensions(fraction.getClass().getName(), extensions.stream().map(Objects::toString).collect(Collectors.toList()));
                    }
                    if (!extensions.isEmpty()) {
                        this.add((Extension)extensions.get(0));
                    }
                }
            }
        }
        catch (ClassNotFoundException | ModuleLoadException e) {
            throw new RuntimeException(e);
        }
    }

    private void add(Extension ext) {
        ParsingContext ctx = new ParsingContext();
        ext.initializeParsers((ExtensionParsingContext)ctx);
    }

    class ParsingContext
    implements ExtensionParsingContext {
        ParsingContext() {
        }

        public ProcessType getProcessType() {
            return ProcessType.STANDALONE_SERVER;
        }

        public RunningMode getRunningMode() {
            return RunningMode.NORMAL;
        }

        public void setSubsystemXmlMapping(String localName, String namespace, XMLElementReader<List<ModelNode>> parser) {
            StandaloneXMLParserProducer.this.parser.addDelegate(new QName(namespace, "subsystem"), parser);
        }

        public void setProfileParsingCompletionHandler(ProfileParsingCompletionHandler profileParsingCompletionHandler) {
        }
    }
}

