/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.SimpleKey;

public class ConfigNode {
    private Map<SimpleKey, ConfigNode> children = new HashMap<SimpleKey, ConfigNode>();
    private Object value;

    public ConfigNode() {
    }

    ConfigNode(Object value) {
        this.value = value;
    }

    public void child(SimpleKey key, Object value) {
        if (value instanceof ConfigNode) {
            this.children.put(key, (ConfigNode)value);
        } else {
            this.children.put(key, new ConfigNode(value));
        }
    }

    public void child(String key, Object value) {
        this.child(new SimpleKey(key), value);
    }

    public void recursiveChild(String key, Object value) {
        this.recursiveChild(ConfigKey.parse((String)key), value);
    }

    public void recursiveChild(ConfigKey key, Object value) {
        ConfigKey rest;
        SimpleKey head = key.head();
        if (head == ConfigKey.EMPTY) {
            this.value(value);
        }
        if ((rest = key.subkey(1)) == ConfigKey.EMPTY) {
            this.child(head, value);
        } else {
            ConfigNode child = this.child(head);
            if (child == null) {
                child = new ConfigNode();
                this.child(head, (Object)child);
            }
            child.recursiveChild(rest, value);
        }
    }

    ConfigNode descendant(ConfigKey key) {
        SimpleKey head = key.head();
        if (head == ConfigKey.EMPTY) {
            return this;
        }
        ConfigKey rest = key.subkey(1);
        ConfigNode child = this.child(head);
        if (child == null) {
            return null;
        }
        return child.descendant(rest);
    }

    ConfigNode child(SimpleKey key) {
        ConfigNode child = this.children.get(key);
        return child;
    }

    ConfigNode child(String key) {
        return this.child(new SimpleKey(key));
    }

    public Set<SimpleKey> childrenKeys() {
        return this.children.keySet();
    }

    public Stream<ConfigKey> allKeysRecursively() {
        Stream<ConfigKey> str = Stream.empty();
        if (this.value != null) {
            str = Stream.of(ConfigKey.EMPTY);
        }
        str = Stream.concat(str, this.children.entrySet().stream().flatMap(kv -> {
            ConfigKey key = (ConfigKey)kv.getKey();
            Object value = kv.getValue();
            if (value instanceof ConfigNode) {
                return ((ConfigNode)value).allKeysRecursively().map(childKey -> key.append(childKey));
            }
            return Stream.empty();
        }));
        return str;
    }

    void value(Object value) {
        if (value instanceof ConfigNode) {
            throw new RuntimeException("Cannot set config-node as a value of a tree config-node");
        }
        this.value = value;
    }

    public Object valueOf(ConfigKey key) {
        SimpleKey head = key.head();
        if (head == ConfigKey.EMPTY) {
            return this.value;
        }
        ConfigNode child = this.child(head);
        if (child != null) {
            ConfigKey rest = key.subkey(1);
            return child.valueOf(rest);
        }
        return null;
    }

    public String toString() {
        return "[ConfigNode: (" + System.identityHashCode(this.children) + ") children=" + this.children + "; value=" + this.value + "]";
    }
}

