/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import javax.enterprise.inject.Vetoed;
import org.wildfly.swarm.container.config.ConfigNode;
import org.wildfly.swarm.container.config.ConfigResolutionStrategy;
import org.wildfly.swarm.spi.api.config.Builder;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.api.config.Resolver;
import org.wildfly.swarm.spi.api.config.SimpleKey;

@Vetoed
public class ConfigViewImpl
implements ConfigView {
    private Properties properties;
    private ConfigNode defaultConfig;
    private Map<String, List<ConfigNode>> registry = new HashMap<String, List<ConfigNode>>();
    private ConfigResolutionStrategy strategy;

    public ConfigViewImpl withProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public ConfigViewImpl withDefaults(ConfigNode defaultConfig) {
        this.defaultConfig = defaultConfig;
        return this;
    }

    public synchronized void register(String name, ConfigNode config) {
        List<ConfigNode> nodes = this.registry.get(name);
        if (nodes == null) {
            nodes = new ArrayList<ConfigNode>();
            this.registry.put(name, nodes);
        }
        nodes.add(config);
    }

    public Set<String> registered() {
        return this.registry.keySet();
    }

    public Object valueOf(ConfigKey key) {
        return this.strategy.valueOf(key);
    }

    public void activate(String ... names) {
        this.strategy = new ConfigResolutionStrategy(this.properties);
        for (String name : names) {
            List<ConfigNode> nodes = this.registry.get(name);
            if (nodes == null) continue;
            nodes.forEach(node -> this.strategy.add((ConfigNode)node));
        }
        if (this.defaultConfig != null) {
            this.strategy.add(this.defaultConfig);
        }
        this.strategy.activate();
    }

    public void activate(List<String> names) {
        this.activate(names.toArray(new String[0]));
    }

    public Properties asProperties() {
        return this.strategy.asProperties();
    }

    public Set<SimpleKey> simpleSubkeys(ConfigKey prefix) {
        return this.strategy.simpleSubkeysOf(prefix);
    }

    public boolean hasKeyOrSubkeys(ConfigKey subPrefix) {
        return this.strategy.hasKeyOrSubkeys(subPrefix);
    }

    public Resolver<String> resolve(ConfigKey key) {
        return new Builder((ConfigView)this, key).as(String.class);
    }

    public Stream<ConfigKey> allKeysRecursively() {
        return this.strategy.allKeysRecursively();
    }
}

