/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.util.Properties;

interface PropertiesManipulator {
    public static PropertiesManipulator system() {
        return SystemPropertiesManipulator.INSTANCE;
    }

    public static PropertiesManipulator forProperties(Properties properties) {
        return new ObjectPropertiesManipulator(properties);
    }

    public String getProperty(String var1);

    public void setProperty(String var1, String var2);

    public Properties getProperties();

    public static class ObjectPropertiesManipulator
    implements PropertiesManipulator {
        private final Properties properties;

        private ObjectPropertiesManipulator(Properties properties) {
            this.properties = properties;
        }

        @Override
        public String getProperty(String name) {
            return this.properties.getProperty(name);
        }

        @Override
        public void setProperty(String name, String value) {
            this.properties.setProperty(name, value);
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }
    }

    public static class SystemPropertiesManipulator
    implements PropertiesManipulator {
        private static SystemPropertiesManipulator INSTANCE = new SystemPropertiesManipulator();

        private SystemPropertiesManipulator() {
        }

        @Override
        public String getProperty(String name) {
            return System.getProperty(name);
        }

        @Override
        public void setProperty(String name, String value) {
            System.setProperty(name, value);
        }

        @Override
        public Properties getProperties() {
            return System.getProperties();
        }
    }
}

