/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.ArchivePreparer;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.spi.api.Module;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;
import org.wildfly.swarm.spi.api.annotations.DeploymentModules;

@Singleton
public class DeploymentModulesArchivePreparer
implements ArchivePreparer {
    @Inject
    @Any
    private Instance<Fraction> allFractions;

    public void prepareArchive(Archive<?> archive) {
        JARArchive jarArchive = (JARArchive)archive.as(JARArchive.class);
        for (Fraction each : this.allFractions) {
            DeploymentModules plural = each.getClass().getAnnotation(DeploymentModules.class);
            if (plural != null) {
                DeploymentModule[] entries;
                for (DeploymentModule entry : entries = plural.value()) {
                    this.addModule(jarArchive, entry);
                }
                continue;
            }
            DeploymentModule entry = each.getClass().getAnnotation(DeploymentModule.class);
            if (entry == null) continue;
            this.addModule(jarArchive, entry);
        }
    }

    protected void addModule(JARArchive archive, DeploymentModule entry) {
        SwarmMessages.MESSAGES.deploymentModuleAdded(entry);
        String moduleName = entry.name();
        String moduleSlot = entry.slot();
        if (moduleSlot.equals("")) {
            moduleSlot = "main";
        }
        Module def = archive.addModule(moduleName, moduleSlot);
        def.withExport(Boolean.valueOf(entry.export()));
        def.withMetaInf(entry.metaInf().toString().toLowerCase());
        def.withServices(entry.services());
    }
}

