/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi.configurable;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.inject.Singleton;
import org.wildfly.swarm.container.runtime.ConfigurableManager;
import org.wildfly.swarm.container.runtime.cdi.configurable.ConfigurableInjectionTarget;
import org.wildfly.swarm.spi.api.ArchiveMetadataProcessor;
import org.wildfly.swarm.spi.api.ArchivePreparer;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.annotations.Configurable;

public class ConfigurableExtension
implements Extension {
    private final ConfigurableManager configurableManager;
    private static final Set<Class<?>> APPLICABLE_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(Customizer.class);
            this.add(ArchivePreparer.class);
            this.add(ArchiveMetadataProcessor.class);
        }
    };

    public ConfigurableExtension(ConfigurableManager configurableManager) {
        this.configurableManager = configurableManager;
    }

    void processInjectionTarget(@Observes ProcessInjectionTarget pit, BeanManager beanManager) throws InstantiationException, IllegalAccessException {
        if (ConfigurableExtension.isApplicable(pit.getAnnotatedType())) {
            pit.setInjectionTarget(new ConfigurableInjectionTarget(pit.getInjectionTarget(), this.configurableManager));
        }
    }

    static <T> boolean isApplicable(AnnotatedType<T> at) {
        if (ConfigurableExtension.isApplicable(at.getJavaClass())) {
            return true;
        }
        Set fields = at.getFields();
        for (AnnotatedField field : fields) {
            if (!field.isAnnotationPresent(Configurable.class)) continue;
            return true;
        }
        return false;
    }

    static boolean isApplicable(Class<?> cls) {
        for (Class<?> each : APPLICABLE_CLASSES) {
            if (!each.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) {
        abd.addBean().types(new Type[]{ConfigurableManager.class}).scope(Singleton.class).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).producing((Object)this.configurableManager);
    }
}

