/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.util;

import java.io.IOException;
import java.io.Writer;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class XmlWriter
implements AutoCloseable {
    private static final String GREATER_THAN = ">";
    private final Writer out;

    public XmlWriter(Writer out) {
        this.out = out;
    }

    public Element element(String name) throws IOException {
        return new Element(name);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Vetoed
    public class Element {
        private String name;
        private boolean hasContent = false;

        Element(String name) throws IOException {
            this.name = name;
            XmlWriter.this.out.write("<" + name);
        }

        public Element attr(String name, String value) throws IOException {
            XmlWriter.this.out.write(" " + name + "=\"" + value + "\"");
            return this;
        }

        public Element element(String name) throws IOException {
            if (!this.hasContent) {
                this.hasContent = true;
                XmlWriter.this.out.write(XmlWriter.GREATER_THAN);
            }
            return new Element(name);
        }

        public Element content(String content) throws IOException {
            if (!this.hasContent) {
                this.hasContent = true;
                XmlWriter.this.out.write(XmlWriter.GREATER_THAN);
            }
            XmlWriter.this.out.write(content);
            return this;
        }

        public void end() throws IOException {
            if (this.hasContent) {
                XmlWriter.this.out.write("</" + this.name + XmlWriter.GREATER_THAN);
            } else {
                XmlWriter.this.out.write("/>");
            }
        }
    }
}

