package org.wildfly.swarm.internal;

import java.io.Serializable;
import javax.annotation.Generated;
import java.lang.RuntimeException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.net.URL;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-03-01T03:24:21-0700")
public class SwarmConfigMessages_$logger extends DelegatingBasicLogger implements SwarmConfigMessages,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SwarmConfigMessages_$logger.class.getName();
    public SwarmConfigMessages_$logger(final Logger log) {
        super(log);
    }
    private static final String missingStageConfig = "WFSWARM0001: Stage config is not present.";
    protected String missingStageConfig$str() {
        return missingStageConfig;
    }
    @Override
    public final RuntimeException missingStageConfig() {
        final RuntimeException result = new RuntimeException(String.format(missingStageConfig$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String stageNotFound = "WFSWARM0003: Project stage '%s' cannot be found.";
    protected String stageNotFound$str() {
        return stageNotFound;
    }
    @Override
    public final RuntimeException stageNotFound(final String stageName) {
        final RuntimeException result = new RuntimeException(String.format(stageNotFound$str(), stageName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedLoadingStageConfig = "WFSWARM0010: Failed to load stage configuration from URL : %s";
    protected String failedLoadingStageConfig$str() {
        return failedLoadingStageConfig;
    }
    @Override
    public final RuntimeException failedLoadingStageConfig(final Throwable cause, final URL url) {
        final RuntimeException result = new RuntimeException(String.format(failedLoadingStageConfig$str(), url), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingDefaultStage = "WFSWARM0011: Missing stage 'default' in project-stages.yml";
    protected String missingDefaultStage$str() {
        return missingDefaultStage;
    }
    @Override
    public final RuntimeException missingDefaultStage() {
        final RuntimeException result = new RuntimeException(String.format(missingDefaultStage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void stageConfigLocation(final String configType, final String configLocation) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, stageConfigLocation$str(), configType, configLocation);
    }
    private static final String stageConfigLocation = "WFSWARM0020: Stage Config found in %s at location: %s";
    protected String stageConfigLocation$str() {
        return stageConfigLocation;
    }
    @Override
    public final void malformedStageConfigUrl(final String error) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, malformedStageConfigUrl$str(), error);
    }
    private static final String malformedStageConfigUrl = "WFSWARM0021: Failed to parse project stage URL reference, ignoring: %s";
    protected String malformedStageConfigUrl$str() {
        return malformedStageConfigUrl;
    }
    @Override
    public final void stageConfigSuperseded(final String location) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, stageConfigSuperseded$str(), location);
    }
    private static final String stageConfigSuperseded = "WFSWARM0022: Project stage superseded by external configuration %s";
    protected String stageConfigSuperseded$str() {
        return stageConfigSuperseded;
    }
    @Override
    public final void usingProjectStage(final String stageName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, usingProjectStage$str(), stageName);
    }
    private static final String usingProjectStage = "WFSWARM0024: Using project stage: %s";
    protected String usingProjectStage$str() {
        return usingProjectStage;
    }
    @Override
    public final void marshalProjectStageProperty(final String key) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, marshalProjectStageProperty$str(), key);
    }
    private static final String marshalProjectStageProperty = "WFSWARM0030: Marshalling Project Stage property %s";
    protected String marshalProjectStageProperty$str() {
        return marshalProjectStageProperty;
    }
    @Override
    public final void marshalXml(final String location, final String xml) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, marshalXml$str(), location, xml);
    }
    private static final String marshalXml = "WFSWARM0031: Marshalling XML from %s as: \n %s";
    protected String marshalXml$str() {
        return marshalXml;
    }
    @Override
    public final void loadingStandaloneXml(final String loader, final String location) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, loadingStandaloneXml$str(), loader, location);
    }
    private static final String loadingStandaloneXml = "WFSWARM0032: Load standalone.xml via %s from %s";
    protected String loadingStandaloneXml$str() {
        return loadingStandaloneXml;
    }
    @Override
    public final void configuration(final String configuration) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, configuration$str(), configuration);
    }
    private static final String configuration = "WFSWARM0037: Configuration:\n%s";
    protected String configuration$str() {
        return configuration;
    }
}
