/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.enterprise.inject.Vetoed;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.container.config.ClassLoaderConfigLocator;
import org.wildfly.swarm.container.config.ConfigLocator;
import org.wildfly.swarm.container.config.ConfigNode;
import org.wildfly.swarm.container.config.ConfigViewImpl;
import org.wildfly.swarm.container.config.FilesystemConfigLocator;
import org.wildfly.swarm.container.config.MapConfigNodeFactory;
import org.wildfly.swarm.container.config.PropertiesConfigNodeFactory;
import org.yaml.snakeyaml.Yaml;

@Vetoed
public class ConfigViewFactory {
    private static final String STAGES = "stages";
    private final ConfigViewImpl configView;
    private List<ConfigLocator> locators = new ArrayList<ConfigLocator>();
    private static final String PROJECT_PREFIX = "project";
    private static final String STAGE = "stage";
    private static final String DEFAULT = "default";

    public static ConfigViewFactory defaultFactory() throws ModuleLoadException {
        return ConfigViewFactory.defaultFactory(null);
    }

    public static ConfigViewFactory defaultFactory(Properties properties) throws ModuleLoadException {
        return new ConfigViewFactory(properties, new FilesystemConfigLocator(), ClassLoaderConfigLocator.system(), ClassLoaderConfigLocator.forApplication());
    }

    private ConfigViewFactory(Properties properties) {
        this.configView = new ConfigViewImpl().withProperties(properties);
    }

    public ConfigViewFactory(Properties properties, ConfigLocator ... locators) {
        this(properties);
        for (ConfigLocator locator : locators) {
            this.addLocator(locator);
        }
    }

    public void addLocator(ConfigLocator locator) {
        this.locators.add(locator);
    }

    public ConfigViewFactory load(String profileName) {
        this.locators.stream().flatMap(locator -> {
            try {
                return locator.locate(profileName);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).forEach(url -> {
            try {
                this.load(profileName, (URL)url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return this;
    }

    public void load(String profileName, URL url) throws IOException {
        if (url.getPath().endsWith(".properties")) {
            this.loadProperties(profileName, url);
        } else if (url.getPath().endsWith(".yml")) {
            this.loadYaml(profileName, url);
        }
    }

    protected void loadProperties(String profileName, URL url) throws IOException {
        Properties props = new Properties();
        props.load(url.openStream());
        ConfigNode configNode = PropertiesConfigNodeFactory.load(props);
        this.configView.register(profileName, configNode);
        this.configView.withProfile(profileName);
    }

    protected void loadYaml(String profileName, URL url) throws IOException {
        if (profileName.equals(STAGES) || url.getPath().endsWith("-stages.yml")) {
            this.loadProjectStages(url);
            return;
        }
        this.loadYamlProjectConfig(profileName, url);
    }

    public ConfigViewImpl get() {
        return this.configView;
    }

    public ConfigViewImpl get(boolean activate) {
        this.configView.activate();
        return this.configView;
    }

    private void loadProjectStages(URL url) throws IOException {
        this.loadProjectStages(url.openStream());
    }

    private void loadProjectStages(InputStream inputStream) {
        Yaml yaml = new Yaml();
        Iterable docs = yaml.loadAll(inputStream);
        for (Object item : docs) {
            Map doc = (Map)item;
            String name = DEFAULT;
            if (doc.get(PROJECT_PREFIX) != null) {
                name = (String)((Map)doc.get(PROJECT_PREFIX)).get(STAGE);
                doc.remove(PROJECT_PREFIX);
            }
            ConfigNode node = MapConfigNodeFactory.load(doc);
            if (name.equals(DEFAULT)) {
                this.configView.withDefaults(node);
                continue;
            }
            this.configView.register(name, node);
        }
    }

    private void loadYamlProjectConfig(String name, URL url) throws IOException {
        this.loadYamlProjectConfig(name, url.openStream());
    }

    private void loadYamlProjectConfig(String name, InputStream inputStream) {
        Yaml yaml = new Yaml();
        Map doc = (Map)yaml.load(inputStream);
        ConfigNode node = MapConfigNodeFactory.load(doc);
        this.configView.register(name, node);
        this.configView.withProfile(name);
    }
}

