/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.marshal;

import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.wildfly.swarm.container.runtime.marshal.ConfigurationMarshaller;
import org.wildfly.swarm.spi.api.OutboundSocketBinding;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;

@ApplicationScoped
public class SocketBindingGroupMarshaller
implements ConfigurationMarshaller {
    @Inject
    @Any
    private Instance<SocketBindingGroup> socketBindingGroups;

    @Override
    public void marshal(List<ModelNode> list) {
        for (SocketBindingGroup group : this.socketBindingGroups) {
            PathAddress address = PathAddress.pathAddress((String)"socket-binding-group", (String)group.name());
            ModelNode node = new ModelNode();
            node.get("operation").set("add");
            node.get("address").set(address.toModelNode());
            node.get("default-interface").set(group.defaultInterface());
            node.get("port-offset").set(new ValueExpression(group.portOffsetExpression()));
            LinkedList<ModelNode> subList = new LinkedList<ModelNode>();
            subList.add(node);
            for (SocketBinding binding : group.socketBindings()) {
                this.configureSocketBinding(address, binding, subList);
            }
            for (SocketBinding binding : group.outboundSocketBindings()) {
                this.configureSocketBinding(address, (OutboundSocketBinding)binding, subList);
            }
            if (this.isAlreadyConfigured(subList, list)) continue;
            list.addAll(subList);
        }
    }

    private void configureSocketBindings(PathAddress address, SocketBindingGroup group, List<ModelNode> list) {
        List socketBindings = group.socketBindings();
        for (SocketBinding each : socketBindings) {
            this.configureSocketBinding(address, each, list);
        }
        List outboundSocketBindings = group.outboundSocketBindings();
        for (OutboundSocketBinding each : outboundSocketBindings) {
            this.configureSocketBinding(address, each, list);
        }
    }

    private void configureSocketBinding(PathAddress address, SocketBinding binding, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.append("socket-binding", binding.name()).toModelNode());
        node.get("operation").set("add");
        node.get("port").set(new ValueExpression(binding.portExpression()));
        if (binding.multicastAddress() != null) {
            node.get("multicast-address").set(binding.multicastAddress());
        }
        if (binding.multicastPortExpression() != null) {
            node.get("multicast-port").set(new ValueExpression(binding.multicastPortExpression()));
        }
        list.add(node);
    }

    private void configureSocketBinding(PathAddress address, OutboundSocketBinding binding, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.append("remote-destination-outbound-socket-binding", binding.name()).toModelNode());
        node.get("operation").set("add");
        node.get("host").set(new ValueExpression(binding.remoteHostExpression()));
        node.get("port").set(new ValueExpression(binding.remotePortExpression()));
        list.add(node);
    }
}

