/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.util.Collection;
import java.util.List;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.container.DeploymentException;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;

@MessageLogger(projectCode="WFSWARM", length=4)
public interface SwarmMessages
extends BasicLogger {
    public static final SwarmMessages MESSAGES = (SwarmMessages)Logger.getMessageLogger(SwarmMessages.class, (String)"org.wildfly.swarm");

    @Message(id=2, value="Cannot invoke %s on a container that has not been started.")
    public IllegalStateException containerNotStarted(String var1);

    @Message(id=4, value="%s requires an argument.")
    public RuntimeException argumentRequired(String var1);

    @Message(id=5, value="Unable to create default deployment")
    public DeploymentException cannotCreateDefaultDeployment();

    @Message(id=6, value="Failed to mount deployment.")
    public DeploymentException failToMountDeployment(@Cause Throwable var1, @Param Archive<?> var2);

    @Message(id=7, value="Deployment failed: %s")
    public String deploymentFailed(String var1);

    @Message(id=8, value="Failure during deployment")
    public DeploymentException deploymentFailed(@Cause Throwable var1, @Param Archive<?> var2);

    @Message(id=9, value="JavaArchive spec does not support Libraries")
    public UnsupportedOperationException librariesNotSupported();

    @Message(id=12, value="Fraction \"%s\" was configured using @WildFlyExtension with a module='', but has multiple extension classes.  Please use classname='' to specify exactly one, or noClass=true to ignore all. %s")
    public RuntimeException fractionHasMultipleExtensions(String var1, Collection<String> var2);

    @Message(id=13, value="Artifact '%s' not found.")
    public RuntimeException artifactNotFound(String var1);

    @Message(id=14, value="Unable to determine version number from GAV: %s")
    public RuntimeException unableToDetermineVersion(String var1);

    @Message(id=15, value="GAV must includes at least 2 segments")
    public RuntimeException gavMinimumSegments();

    @Message(id=16, value="System property '%s' not provided.")
    public IllegalStateException systemPropertyNotFound(String var1);

    @Message(id=17, value="Cannot identify FileSystemLayout for given path: %s")
    public IllegalArgumentException cannotIdentifyFileSystemLayout(String var1);

    @Message(id=18, value="Installed fraction: %24s - %-15s %s:%s:%s")
    public String availableFraction(String var1, String var2, String var3, String var4, String var5);

    @Message(id=19, value="No deployments specified on the command-line")
    public String noDeploymentsSpecified();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=23, value="Unable to setup Shrinkwrap Domain")
    public void shrinkwrapDomainSetupFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=25, value="Add deployment module: %s")
    public void deploymentModuleAdded(DeploymentModule var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=26, value="Calling Pre Customizer: %s")
    public void callingPreCustomizer(Customizer var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=27, value="Calling Post Customizer: %s")
    public void callingPostCustomizer(Customizer var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=28, value="WildFly Bootstrap operations: \n %s")
    public void wildflyBootstrap(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="Install MSC service for command line args: %s")
    public void argsInstalled(List<String> var1);

    @Message(id=33, value="HTTP/S is configured correctly, but org.wildfly.swarm:management is not available")
    public RuntimeException httpsRequiresManagementFraction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=34, value="Ignoring subsystem %s:%s")
    public void ignoringSubsystem(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=35, value="Failed to register modules mbeans")
    public void moduleMBeanServerNotInstalled(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=36, value="Error installing user-space CDI extension: %s")
    public void errorInstallingUserSpaceExtension(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=38, value="In order to use HTTP/2 in WildFly Swarm, you must have the OpenSSL provider with ALPN capability from JBoss Core Services installed and configured. This is due to the fact that HTTP/2 requires a TLS stack that supports ALPN, which is not provided by the default installation of Java 8. HTTP/2 will only work with browsers that also support the HTTP/2 standard. OpenSSL usage with WildFly Swarm on HP-UX is NOT supported.")
    public void http2NotSupported();

    @Message(id=40, value="This version of WildFly Swarm does not support generating self signed certificates.")
    public RuntimeException generateSelfSignedCertificateNotSupported();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=41, value="Error invoking SslServerIdentity.generateSelfSignedCertificateHost(String) in HTTPSCustomizer.")
    public void failToInvokeGenerateSelfSignedCertificateHost(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=99999, value="WildFly Swarm is Ready")
    public void wildflySwarmIsReady();
}

