/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.Swarm;
import org.wildfly.swarm.container.runtime.RuntimeDeployer;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.api.config.SimpleKey;

@ApplicationScoped
public class ArtifactDeployer {
    @Inject
    ConfigView configView;
    @Inject
    private Instance<RuntimeDeployer> deployer;

    public void deploy() throws Exception {
        Set subkeys = this.configView.simpleSubkeys(ConfigKey.of((String[])new String[]{"swarm", "deployment"}));
        for (SimpleKey subkey : subkeys) {
            String spec = subkey.name();
            if (!spec.contains(":")) continue;
            String[] parts = spec.split(":");
            String groupId = parts[0];
            parts = parts[1].split("\\.");
            String artifactId = parts[0];
            String packaging = parts[1];
            JavaArchive artifact = Swarm.artifact(groupId + ":" + artifactId + ":" + packaging + ":*", artifactId + "." + packaging);
            ((RuntimeDeployer)this.deployer.get()).deploy((Archive<?>)artifact, spec);
        }
    }
}

