/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.container.runtime.ConfigurableHandle;
import org.wildfly.swarm.container.runtime.ObjectBackedConfigurableHandle;
import org.wildfly.swarm.container.runtime.cdi.DeploymentContext;
import org.wildfly.swarm.internal.SwarmConfigMessages;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.Configurables;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.api.config.Converter;
import org.wildfly.swarm.spi.api.config.Resolver;
import org.wildfly.swarm.spi.api.config.SimpleKey;

public class ConfigurableManager
implements AutoCloseable {
    private static final String SUBRESOURCES = "subresources";
    private static final String ACCEPT = "accept";
    private static final Set<String> BLACKLISTED_FIELDS = new HashSet<String>(){
        {
            this.add("pcs");
            this.add("key");
            this.add(ConfigurableManager.SUBRESOURCES);
        }
    };
    private static final Set<Class<?>> BLACKLISTED_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(List.class);
            this.add(Map.class);
            this.add(Properties.class);
        }
    };
    private static final Set<Class<?>> CONFIGURABLE_VALUE_TYPES = new HashSet<Class<?>>(){
        {
            this.add(Boolean.class);
            this.add(Boolean.TYPE);
            this.add(Short.class);
            this.add(Short.TYPE);
            this.add(Integer.class);
            this.add(Integer.TYPE);
            this.add(Long.class);
            this.add(Long.TYPE);
            this.add(Float.class);
            this.add(Float.TYPE);
            this.add(String.class);
            this.add(List.class);
            this.add(Map.class);
            this.add(Properties.class);
            this.add(Defaultable.class);
        }
    };
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.config");
    private final List<ConfigurableHandle> configurables = new ArrayList<ConfigurableHandle>();
    private final List<Object> deferred = new ArrayList<Object>();
    private final ConfigView configView;
    private static ConfigKey DEPLOYMENT_PREFIX = ConfigKey.parse((String)"swarm.deployment.*");
    private final DeploymentContext deploymentContext;
    private boolean rescanning;

    public ConfigurableManager(ConfigView configView, DeploymentContext deploymentContext) {
        this.configView = configView;
        this.deploymentContext = deploymentContext;
    }

    public ConfigView configView() {
        return this.configView;
    }

    public List<ConfigurableHandle> configurables() {
        return this.configurables;
    }

    protected <T> boolean configure(ConfigurableHandle configurable) throws Exception {
        block26: {
            if (this.rescanning) {
                return true;
            }
            try (AutoCloseable handle = Performance.accumulate((String)"ConfigurableManager#configure");){
                Resolver<Properties> resolver = this.configView.resolve(configurable.key());
                Class<?> resolvedType = configurable.type();
                boolean isList = false;
                boolean isMap = false;
                boolean isProperties = false;
                if (resolvedType.isEnum()) {
                    resolver = resolver.as(resolvedType, this.converter(resolvedType));
                } else if (List.class.isAssignableFrom(resolvedType)) {
                    isList = true;
                    resolver = this.listResolver((Resolver<String>)resolver, configurable.key());
                } else if (Map.class.isAssignableFrom(resolvedType)) {
                    isMap = true;
                    resolver = this.mapResolver(resolver, configurable.key());
                } else if (Properties.class.isAssignableFrom(resolvedType)) {
                    isProperties = true;
                    resolver = this.propertiesResolver(resolver, configurable.key());
                } else {
                    resolver = resolver.as(resolvedType);
                }
                if (!isList && !isMap && !isProperties && !resolver.hasValue()) break block26;
                Object resolvedValue = resolver.getValue();
                if (isList && ((List)resolvedValue).isEmpty()) {
                    break block26;
                }
                if (isMap && ((Map)resolvedValue).isEmpty()) {
                    break block26;
                }
                if (isProperties && ((Properties)resolvedValue).isEmpty()) {
                    break block26;
                }
                configurable.set(resolvedType.cast(resolvedValue));
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private <ENUMTYPE extends Enum<ENUMTYPE>> Converter<ENUMTYPE> converter(Class<ENUMTYPE> enumType) {
        return str -> {
            try {
                return Enum.valueOf(enumType, str.toUpperCase().replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid value '" + str + "'; should be one of: " + String.join((CharSequence)",", Arrays.stream(enumType.getEnumConstants()).map(constant -> constant.toString()).collect(Collectors.toList())));
            }
        };
    }

    private Resolver<List> listResolver(Resolver<String> resolver, ConfigKey key) {
        return resolver.withDefault((Object)"").as(List.class, this.listConverter(key));
    }

    private Converter<List> listConverter(ConfigKey key) {
        return ignored -> this.configView.simpleSubkeys(key).stream().map(subKey -> (String)this.configView.resolve(key.append((ConfigKey)subKey)).getValue()).collect(Collectors.toList());
    }

    private Resolver<Map> mapResolver(Resolver<String> resolver, ConfigKey key) {
        return resolver.withDefault((Object)"").as(Map.class, this.mapConverter(key));
    }

    private Converter<Map> mapConverter(ConfigKey key) {
        return ignored -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Set subKeys = this.configView.simpleSubkeys(key);
            for (SimpleKey subKey : subKeys) {
                map.put(subKey.name(), this.configView.resolve(key.append((ConfigKey)subKey)).getValue());
            }
            return map;
        };
    }

    private Resolver<Properties> propertiesResolver(Resolver<String> resolver, ConfigKey key) {
        return resolver.withDefault((Object)"").as(Properties.class, this.propertiesConverter(key));
    }

    private Converter<Properties> propertiesConverter(ConfigKey key) {
        return ignored -> {
            Properties props = new Properties();
            Set subKeys = this.configView.simpleSubkeys(key);
            for (SimpleKey subKey : subKeys) {
                props.setProperty(subKey.name(), (String)this.configView.resolve(key.append((ConfigKey)subKey)).getValue());
            }
            return props;
        };
    }

    public void rescan() throws Exception {
        this.rescanning = true;
        try {
            for (Object each : this.deferred) {
                this.scanInternal(each);
            }
        }
        finally {
            this.rescanning = false;
        }
    }

    public void scan(Object instance) throws Exception {
        try (AutoCloseable handle = Performance.accumulate((String)"ConfigurableManager#scan");){
            this.deferred.add(instance);
            this.scanInternal(instance);
        }
    }

    private void scanInternal(Object instance) throws Exception {
        if (instance instanceof Fraction) {
            this.scanFraction((Fraction)instance);
        } else {
            this.scan(null, instance, false);
        }
    }

    protected void scanFraction(Fraction fraction) throws Exception {
        ConfigKey prefix = this.nameFor(fraction);
        this.scan(prefix, fraction, true);
    }

    protected SimpleKey getKey(Object object) throws Exception {
        Object key;
        if (object instanceof Keyed) {
            return new SimpleKey(((Keyed)object).getKey());
        }
        Method getKey = this.findGetKeyMethod(object);
        if (getKey != null && (key = getKey.invoke(object, new Object[0])) != null) {
            return new SimpleKey(key.toString());
        }
        return null;
    }

    protected Method findGetKeyMethod(Object object) {
        Method[] methods;
        for (Method method : methods = object.getClass().getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || !method.getName().equals("getKey") || method.getParameterCount() != 0) continue;
            return method;
        }
        return null;
    }

    protected ConfigKey nameFor(Fraction fraction) throws Exception {
        Configurable anno = fraction.getClass().getAnnotation(Configurable.class);
        if (anno != null) {
            return ConfigKey.parse((String)anno.value());
        }
        SimpleKey key = this.getKey(fraction);
        if (key == null) {
            key = new SimpleKey(fraction.getClass().getSimpleName().replace("Fraction", "").toLowerCase());
        }
        return ConfigKey.of((String[])new String[]{"swarm"}).append((ConfigKey)key);
    }

    protected void scan(ConfigKey prefix, Object instance, boolean implicit) throws Exception {
        this.scan(prefix, instance, instance.getClass(), implicit);
        if (implicit) {
            this.scanSubresources(prefix, instance);
        }
    }

    protected void scan(ConfigKey prefix, Object instance, Class<?> curClass, boolean implicit) throws Exception {
        Field[] fields;
        if (curClass == null || curClass == Object.class || this.isBlacklisted(curClass)) {
            return;
        }
        block0: for (Field field : fields = curClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || this.isBlacklisted(field) || !implicit && field.getAnnotation(Configurable.class) == null && field.getAnnotation(Configurables.class) == null || !this.isConfigurableType(field.getType())) continue;
            List<ConfigKey> names = this.namesFor(prefix, field);
            boolean configured = false;
            for (ConfigKey name : names) {
                if (!this.seen(name)) {
                    ObjectBackedConfigurableHandle configurable = new ObjectBackedConfigurableHandle(name, instance, field);
                    this.configurables.add(configurable);
                    configured = this.configure(configurable);
                }
                if (!configured) continue;
                continue block0;
            }
        }
        if (!this.rescanning) {
            Method[] methods;
            for (Method method : methods = curClass.getDeclaredMethods()) {
                Set keysWithConfiguration;
                if (!method.isAnnotationPresent(Configurable.class)) continue;
                ConfigKey subPrefix = prefix.append(this.nameFor(method));
                if (method.getParameterCount() == 1) {
                    Object lambda;
                    if (!this.configView.hasKeyOrSubkeys(subPrefix) || (lambda = this.createLambda(subPrefix, method)) == null) continue;
                    method.invoke(instance, lambda);
                    continue;
                }
                if (method.getParameterCount() != 2 || (keysWithConfiguration = this.configView.simpleSubkeys(subPrefix)).isEmpty()) continue;
                for (SimpleKey key : keysWithConfiguration) {
                    ConfigKey itemPrefix = subPrefix.append((ConfigKey)key);
                    Object lambda = this.createLambda(itemPrefix, method);
                    if (lambda == null) continue;
                    method.invoke(instance, key.name(), lambda);
                }
            }
        }
        this.scan(prefix, instance, curClass.getSuperclass(), implicit);
    }

    private boolean seen(ConfigKey name) {
        if (this.deploymentContext.isActive()) {
            return false;
        }
        return this.configurables.stream().anyMatch(e -> e.key().equals(name));
    }

    private boolean isConfigurableType(Class<?> type) {
        return type.isEnum() || CONFIGURABLE_VALUE_TYPES.contains(type);
    }

    private boolean isBlacklisted(Class<?> cls) {
        return BLACKLISTED_CLASSES.stream().anyMatch(e -> {
            if (e.isInterface()) {
                for (Class<?> each : cls.getInterfaces()) {
                    if (each != e) continue;
                    return true;
                }
                return false;
            }
            return e == cls;
        });
    }

    private boolean isBlacklisted(Field field) {
        if (BLACKLISTED_FIELDS.stream().anyMatch(e -> e.equals(field.getName()))) {
            return true;
        }
        return this.isBlacklisted(field.getType());
    }

    protected List<ConfigKey> namesFor(ConfigKey prefix, Field field) {
        ArrayList<ConfigKey> names = new ArrayList<ConfigKey>();
        Configurables plural = field.getAnnotation(Configurables.class);
        if (plural != null) {
            for (Configurable each : plural.value()) {
                ConfigKey key = this.nameFor(prefix, each);
                if (key == null) continue;
                names.add(key);
            }
        } else {
            Configurable[] annos = (Configurable[])field.getAnnotationsByType(Configurable.class);
            if (annos != null && annos.length > 0) {
                for (Configurable anno : annos) {
                    ConfigKey key = this.nameFor(prefix, anno);
                    if (key == null) continue;
                    names.add(key);
                }
            } else {
                ConfigKey key = this.handleDeploymentConfiguration(prefix.append(this.nameFor(field)));
                names.add(key);
            }
        }
        return names;
    }

    protected ConfigKey nameFor(ConfigKey prefix, Configurable anno) {
        if (!anno.value().equals("")) {
            return this.handleDeploymentConfiguration(ConfigKey.parse((String)anno.value()));
        }
        if (!anno.simpleName().equals("")) {
            this.handleDeploymentConfiguration(prefix.append(ConfigKey.parse((String)anno.simpleName())));
        }
        return null;
    }

    protected ConfigKey handleDeploymentConfiguration(ConfigKey in) {
        if (!this.deploymentContext.isActive()) {
            return in;
        }
        if (in.isChildOf(DEPLOYMENT_PREFIX)) {
            in.replace(2, this.deploymentContext.getCurrentName());
        }
        return in;
    }

    protected ConfigKey nameFor(Field member) {
        char[] chars;
        StringBuilder str = new StringBuilder();
        for (char c : chars = member.getName().toCharArray()) {
            if (Character.isUpperCase(c)) {
                str.append("-");
            }
            str.append(Character.toLowerCase(c));
        }
        return ConfigKey.of((String[])new String[]{str.toString()});
    }

    protected ConfigKey nameFor(Method member) {
        char[] chars;
        StringBuilder str = new StringBuilder();
        for (char c : chars = member.getName().toCharArray()) {
            if (Character.isUpperCase(c)) {
                str.append("-");
            }
            str.append(Character.toLowerCase(c));
        }
        if (member.getParameterCount() == 2) {
            str.append("s");
        }
        return ConfigKey.of((String[])new String[]{str.toString()});
    }

    protected void scanSubresources(ConfigKey prefix, Object instance) throws Exception {
        Field[] fields;
        Method method = this.getSubresourcesMethod(instance);
        if (method == null) {
            return;
        }
        Object subresources = method.invoke(instance, new Object[0]);
        for (Field field : fields = subresources.getClass().getDeclaredFields()) {
            if (field.getAnnotation(SubresourceInfo.class) == null && List.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            Object value = field.get(subresources);
            ConfigKey subPrefix = prefix.append(this.nameFor(field));
            if (value != null && value instanceof List) {
                Method factoryMethod;
                int index = 0;
                HashSet<SimpleKey> seenKeys = new HashSet<SimpleKey>();
                for (Object each : (List)value) {
                    SimpleKey key = this.getKey(each);
                    ConfigKey itemPrefix = null;
                    if (key != null) {
                        seenKeys.add(key);
                        itemPrefix = subPrefix.append((ConfigKey)key);
                    } else {
                        itemPrefix = subPrefix.append(new String[]{"" + index});
                    }
                    this.scan(itemPrefix, each, true);
                    ++index;
                }
                Set keysWithConfiguration = this.configView.simpleSubkeys(subPrefix);
                keysWithConfiguration.removeAll(seenKeys);
                if (keysWithConfiguration.isEmpty() || (factoryMethod = this.getKeyedFactoryMethod(instance, field)) == null) continue;
                for (SimpleKey key : keysWithConfiguration) {
                    ConfigKey itemPrefix = subPrefix.append((ConfigKey)key);
                    Object lambda = this.createLambda(itemPrefix, factoryMethod);
                    if (lambda == null) continue;
                    factoryMethod.invoke(instance, key.name(), lambda);
                }
                continue;
            }
            if (value == null) {
                Object lambda;
                Method factoryMethod;
                if (!this.configView.hasKeyOrSubkeys(subPrefix) || (factoryMethod = this.getNonKeyedFactoryMethod(instance, field)) == null || (lambda = this.createLambda(subPrefix, factoryMethod)) == null) continue;
                factoryMethod.invoke(instance, lambda);
                continue;
            }
            this.scan(subPrefix, value, true);
        }
    }

    protected Object createLambda(ConfigKey itemPrefix, Method factoryMethod) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> consumerType = factoryMethod.getParameterTypes()[factoryMethod.getParameterCount() - 1];
        try {
            Method acceptMethod = null;
            for (Method method : consumerType.getMethods()) {
                if (!method.getName().equals(ACCEPT)) continue;
                acceptMethod = method;
            }
            if (acceptMethod == null) {
                return null;
            }
            MethodHandle target = lookup.findVirtual(ConfigurableManager.class, "subresourceAdded", MethodType.methodType(Void.TYPE, ConfigKey.class, Object.class));
            MethodType samType = MethodType.methodType(Void.TYPE, acceptMethod.getParameterTypes()[0]);
            MethodHandle mh = LambdaMetafactory.metafactory(lookup, ACCEPT, MethodType.methodType(consumerType, ConfigurableManager.class, ConfigKey.class), samType, target, samType).getTarget();
            return mh.invoke(this, itemPrefix);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void subresourceAdded(ConfigKey itemPrefix, Object object) throws Exception {
        this.scan(itemPrefix, object, true);
    }

    protected Method getKeyedFactoryMethod(Object instance, Field field) {
        SubresourceInfo anno = field.getAnnotation(SubresourceInfo.class);
        if (anno != null) {
            Method[] methods;
            String name = anno.value();
            for (Method method : methods = instance.getClass().getMethods()) {
                if (!method.getName().equals(name) || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 2 || method.getParameterTypes()[0] != String.class || method.getParameterTypes()[1].getAnnotation(FunctionalInterface.class) == null) continue;
                boolean acceptMethodFound = false;
                for (Method paramMethod : method.getParameterTypes()[1].getMethods()) {
                    if (!paramMethod.getName().equals(ACCEPT)) continue;
                    acceptMethodFound = true;
                    break;
                }
                if (!acceptMethodFound) continue;
                return method;
            }
        }
        return null;
    }

    protected Method getNonKeyedFactoryMethod(Object instance, Field field) {
        Method[] methods;
        String name = field.getName();
        for (Method method : methods = instance.getClass().getMethods()) {
            if (!method.getName().equals(name) || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 1 || method.getParameterTypes()[0].getAnnotation(FunctionalInterface.class) == null) continue;
            boolean acceptMethodFound = false;
            for (Method paramMethod : method.getParameterTypes()[0].getMethods()) {
                if (!paramMethod.getName().equals(ACCEPT)) continue;
                acceptMethodFound = true;
                break;
            }
            if (!acceptMethodFound) continue;
            return method;
        }
        return null;
    }

    protected Method getSubresourcesMethod(Object instance) {
        Method[] methods;
        for (Method method : methods = instance.getClass().getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.getName().equals(SUBRESOURCES) || method.getParameterCount() != 0) continue;
            return method;
        }
        return null;
    }

    public void log() {
        boolean verbose = true;
        int longestKey = 0;
        for (ConfigurableHandle each : this.configurables) {
            if (each.key().name().length() <= longestKey) continue;
            longestKey = each.key().name().length();
        }
        StringBuilder str = new StringBuilder();
        List sorted = this.configurables.stream().sorted((l, r) -> l.key().name().compareTo(r.key().name())).collect(Collectors.toList());
        boolean first = true;
        for (ConfigurableHandle each : sorted) {
            try {
                String name = each.key().name();
                Object value = each.currentValue();
                if (value == null && !verbose) continue;
                String printedValue = "(unset)";
                if (value != null) {
                    printedValue = name.toLowerCase().contains("password") ? "<redacted>" : value.toString();
                }
                if (!first) {
                    str.append("\n");
                }
                str.append(String.format("  %-" + longestKey + "s = %s", name, printedValue));
                first = false;
            }
            catch (Exception e) {
                SwarmConfigMessages.MESSAGES.errorResolvingConfigurableValue(each.key().name(), e);
            }
        }
        SwarmConfigMessages.MESSAGES.configuration(str.toString());
    }

    @Override
    public void close() {
        this.configurables.clear();
        this.deferred.clear();
    }
}

