/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.env.FractionManifest;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.container.internal.Server;
import org.wildfly.swarm.container.internal.ServerBootstrap;
import org.wildfly.swarm.container.runtime.ConfigurableManager;
import org.wildfly.swarm.container.runtime.ExtensionPreventionClassLoaderWrapper;
import org.wildfly.swarm.container.runtime.LogSilencer;
import org.wildfly.swarm.container.runtime.RuntimeServer;
import org.wildfly.swarm.container.runtime.cdi.ConfigViewProducingExtension;
import org.wildfly.swarm.container.runtime.cdi.DeploymentContextImpl;
import org.wildfly.swarm.container.runtime.cdi.DeploymentScopedExtension;
import org.wildfly.swarm.container.runtime.cdi.FractionProducingExtension;
import org.wildfly.swarm.container.runtime.cdi.ImplicitArchiveExtension;
import org.wildfly.swarm.container.runtime.cdi.OutboundSocketBindingExtension;
import org.wildfly.swarm.container.runtime.cdi.SocketBindingExtension;
import org.wildfly.swarm.container.runtime.cdi.XMLConfigProducingExtension;
import org.wildfly.swarm.container.runtime.cdi.configurable.ConfigurableExtension;
import org.wildfly.swarm.container.runtime.cli.CommandLineArgsExtension;
import org.wildfly.swarm.internal.OutboundSocketBindingRequest;
import org.wildfly.swarm.internal.SocketBindingRequest;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.internal.SwarmMetricsMessages;
import org.wildfly.swarm.spi.api.ClassLoading;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.config.ConfigView;

public class ServerBootstrapImpl
implements ServerBootstrap {
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm");
    private String[] args;
    private Collection<Fraction> explicitlyInstalledFractions;
    private Set<Class<?>> userComponents;
    private Optional<URL> xmlConfigURL = Optional.empty();
    private boolean bootstrapDebug;
    private List<SocketBindingRequest> socketBindings;
    private List<OutboundSocketBindingRequest> outboundSocketBindings;
    private ConfigView configView;

    @Override
    public ServerBootstrap withArguments(String[] args) {
        this.args = args;
        return this;
    }

    @Override
    public ServerBootstrap withXmlConfig(Optional<URL> url) {
        this.xmlConfigURL = url;
        return this;
    }

    @Override
    public ServerBootstrap withConfigView(ConfigView configView) {
        this.configView = configView;
        return this;
    }

    @Override
    public ServerBootstrap withBootstrapDebug(boolean debugBootstrap) {
        this.bootstrapDebug = debugBootstrap;
        return this;
    }

    @Override
    public ServerBootstrap withExplicitlyInstalledFractions(Collection<Fraction> explicitlyInstalledFractions) {
        this.explicitlyInstalledFractions = explicitlyInstalledFractions;
        return this;
    }

    @Override
    public ServerBootstrap withUserComponents(Set<Class<?>> userComponentClasses) {
        this.userComponents = userComponentClasses;
        return this;
    }

    @Override
    public ServerBootstrap withSocketBindings(List<SocketBindingRequest> bindings) {
        this.socketBindings = bindings;
        return this;
    }

    @Override
    public ServerBootstrap withOutboundSocketBindings(List<OutboundSocketBindingRequest> bindings) {
        this.outboundSocketBindings = bindings;
        return this;
    }

    /*
     * Loose catch block
     */
    @Override
    public Server bootstrap() throws Exception {
        try {
            try (AutoCloseable bootstrap = Performance.time((String)"Bootstrap");){
                Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.container"));
                Server server = (Server)ClassLoading.withTCCL((ClassLoader)new ExtensionPreventionClassLoaderWrapper((ClassLoader)module.getClassLoader()), () -> {
                    try (AutoCloseable logFractionHandle = Performance.time((String)"Log fractions");){
                        this.logFractions();
                    }
                    RuntimeServer outerServer = LogSilencer.silently("org.jboss.weld").execute(() -> {
                        Weld weld = new Weld("internal");
                        weld.setClassLoader((ClassLoader)module.getClassLoader());
                        ConfigViewProducingExtension configViewProducingExtension = new ConfigViewProducingExtension(this.configView);
                        DeploymentContextImpl deploymentContext = new DeploymentContextImpl();
                        ConfigurableManager configurableManager = new ConfigurableManager(this.configView, deploymentContext);
                        weld.addExtension((Extension)new FractionProducingExtension(this.explicitlyInstalledFractions, configurableManager));
                        weld.addExtension((Extension)new ConfigurableExtension(configurableManager));
                        weld.addExtension((Extension)new CommandLineArgsExtension(this.args));
                        weld.addExtension((Extension)configViewProducingExtension);
                        weld.addExtension((Extension)new XMLConfigProducingExtension(this.xmlConfigURL));
                        weld.addExtension((Extension)new OutboundSocketBindingExtension(this.outboundSocketBindings));
                        weld.addExtension((Extension)new SocketBindingExtension(this.socketBindings));
                        weld.addExtension((Extension)new DeploymentScopedExtension(deploymentContext));
                        weld.addExtension((Extension)new ImplicitArchiveExtension());
                        for (Class<?> each : this.userComponents) {
                            weld.addBeanClass(each);
                        }
                        weld.property("org.jboss.weld.se.shutdownHook", (Object)false);
                        WeldContainer weldContainer = null;
                        RuntimeServer server = null;
                        try (AutoCloseable weldRelated = Performance.time((String)"Weld-related");){
                            try (AutoCloseable weldInitHandle = Performance.time((String)"Weld initialize");){
                                weldContainer = weld.initialize();
                            }
                            var11_13 = null;
                            try (AutoCloseable serverSelectHandle = Performance.time((String)"Server construction");){
                                server = (RuntimeServer)weldContainer.select(RuntimeServer.class, new Annotation[0]).get();
                            }
                            catch (Throwable throwable) {
                                var11_13 = throwable;
                                throw throwable;
                            }
                        }
                        return server;
                    });
                    try (AutoCloseable weldInitHandle = Performance.time((String)"Server start");){
                        outerServer.start(true);
                    }
                    return outerServer;
                });
                return server;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            SwarmMetricsMessages.MESSAGES.bootPerformance(Performance.dump());
        }
    }

    protected void logFractions() throws IOException {
        ApplicationEnvironment.get().fractionManifests().forEach(this::logFraction);
    }

    protected void logFraction(FractionManifest manifest) {
        if (manifest.isInternal()) {
            LOG.debug((Object)SwarmMessages.MESSAGES.availableFraction(manifest.getName(), manifest.getStabilityLevel(), manifest.getGroupId(), manifest.getArtifactId(), manifest.getVersion()));
        } else {
            int stabilityIndex = manifest.getStabilityIndex();
            if (stabilityIndex < 3) {
                LOG.warn((Object)SwarmMessages.MESSAGES.availableFraction(manifest.getName(), manifest.getStabilityLevel(), manifest.getGroupId(), manifest.getArtifactId(), manifest.getVersion()));
            } else {
                LOG.info((Object)SwarmMessages.MESSAGES.availableFraction(manifest.getName(), manifest.getStabilityLevel(), manifest.getGroupId(), manifest.getArtifactId(), manifest.getVersion()));
            }
        }
    }
}

