/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.container.runtime.cdi.DeploymentContext;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;

@Vetoed
public class DeploymentContextImpl
implements DeploymentContext {
    private final ThreadLocal<Map<Contextual<?>, ContextualInstance<?>>> currentContext = new ThreadLocal();
    private final ThreadLocal<Archive> currentArchive = new ThreadLocal();
    private final ThreadLocal<String> currentName = new ThreadLocal();

    public Class<? extends Annotation> getScope() {
        return DeploymentScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            throw new ContextNotActiveException();
        }
        ContextualInstance<Object> instance = ctx.get(contextual);
        if (instance == null && creationalContext != null) {
            instance = new ContextualInstance<Object>(contextual.create(creationalContext), creationalContext, contextual);
            ctx.put(contextual, instance);
        }
        return instance != null ? (T)instance.get() : null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return this.currentContext.get() != null;
    }

    public void destroy(Contextual<?> contextual) {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            return;
        }
        ctx.remove(contextual);
    }

    public void activate(Archive archive, String asName) {
        this.currentContext.set(new HashMap());
        this.currentArchive.set(archive);
        this.currentName.set(asName);
    }

    @Override
    public void deactivate() {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            return;
        }
        for (ContextualInstance<?> instance : ctx.values()) {
            try {
                instance.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ctx.clear();
        this.currentContext.remove();
        this.currentArchive.set(null);
        this.currentName.set(null);
    }

    public Archive getCurrentArchive() {
        return this.currentArchive.get();
    }

    @Override
    public String getCurrentName() {
        return this.currentName.get();
    }

    static final class ContextualInstance<T> {
        private final T value;
        private final CreationalContext<T> creationalContext;
        private final Contextual<T> contextual;

        ContextualInstance(T instance, CreationalContext<T> creationalContext, Contextual<T> contextual) {
            this.value = instance;
            this.creationalContext = creationalContext;
            this.contextual = contextual;
        }

        T get() {
            return this.value;
        }

        Contextual<T> getContextual() {
            return this.contextual;
        }

        void destroy() {
            this.contextual.destroy(this.value, this.creationalContext);
        }
    }

    static final class InjectableDeploymentContext
    implements DeploymentContext {
        private static final Logger LOGGER = Logger.getLogger(InjectableDeploymentContext.class.getName());
        private final DeploymentContext delegate;
        private final BeanManager beanManager;
        private boolean isActivator;

        InjectableDeploymentContext(DeploymentContext delegate, BeanManager beanManager) {
            this.delegate = delegate;
            this.beanManager = beanManager;
            this.isActivator = false;
        }

        public void destroy(Contextual<?> contextual) {
            this.delegate.destroy(contextual);
        }

        public Class<? extends Annotation> getScope() {
            return this.delegate.getScope();
        }

        public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
            return (T)this.delegate.get(contextual);
        }

        public <T> T get(Contextual<T> contextual) {
            return (T)this.delegate.get(contextual);
        }

        public boolean isActive() {
            return this.delegate.isActive();
        }

        public void activate(Archive archive, String asName) {
            try {
                this.beanManager.getContext(this.delegate.getScope());
                LOGGER.info("Command context already active");
            }
            catch (ContextNotActiveException e) {
                this.delegate.activate(archive, asName);
                this.isActivator = true;
            }
        }

        @Override
        public void deactivate() {
            if (this.isActivator) {
                this.delegate.deactivate();
            } else {
                LOGGER.info("Command context not activated by this bean");
            }
        }

        public Archive getCurrentArchive() {
            return this.delegate.getCurrentArchive();
        }

        @Override
        public String getCurrentName() {
            return this.delegate.getCurrentName();
        }
    }
}

