/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.xmlconfig;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.RuntimeHostControllerInfoAccessor;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.persistence.XmlConfigurationPersister;
import org.jboss.as.server.parsing.StandaloneXml;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.swarm.container.runtime.xmlconfig.BootstrapConfiguration;

public class BootstrapPersister
implements ExtensibleConfigurationPersister {
    private final File configurationFile;
    private final XmlConfigurationPersister delegate;
    private BootstrapConfiguration bootstrapConfig;

    public BootstrapPersister(BootstrapConfiguration bootstrapConfig, File configurationFile) {
        this.bootstrapConfig = bootstrapConfig;
        this.configurationFile = configurationFile;
        this.delegate = this.createDelegate(configurationFile);
    }

    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        return this.delegate.store(model, affectedAddresses);
    }

    public void marshallAsXml(ModelNode model, OutputStream output) throws ConfigurationPersistenceException {
        this.delegate.marshallAsXml(model, output);
    }

    public List<ModelNode> load() throws ConfigurationPersistenceException {
        if (!this.configurationFile.exists()) {
            return this.bootstrapConfig.get();
        }
        return this.delegate.load();
    }

    public void successfulBoot() throws ConfigurationPersistenceException {
    }

    public String snapshot() throws ConfigurationPersistenceException {
        return null;
    }

    public ConfigurationPersister.SnapshotInfo listSnapshots() {
        return ConfigurationPersister.NULL_SNAPSHOT_INFO;
    }

    public void deleteSnapshot(String name) {
    }

    public void registerSubsystemWriter(String name, XMLElementWriter<SubsystemMarshallingContext> writer) {
        this.delegate.registerSubsystemWriter(name, writer);
    }

    public void unregisterSubsystemWriter(String name) {
        this.delegate.unregisterSubsystemWriter(name);
    }

    private XmlConfigurationPersister createDelegate(File configFile) {
        QName rootElement = new QName(Namespace.CURRENT.getUriString(), "server");
        ExtensionRegistry extensionRegistry = new ExtensionRegistry(ProcessType.SELF_CONTAINED, new RunningModeControl(RunningMode.NORMAL), null, null, RuntimeHostControllerInfoAccessor.SERVER);
        StandaloneXml parser = new StandaloneXml(Module.getBootModuleLoader(), Executors.newSingleThreadExecutor(), extensionRegistry);
        XmlConfigurationPersister persister = new XmlConfigurationPersister(configFile, rootElement, (XMLElementReader)parser, (XMLElementWriter)parser, false);
        return persister;
    }
}

