/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import javax.enterprise.inject.Vetoed;
import org.wildfly.swarm.container.config.ConfigNode;
import org.wildfly.swarm.container.config.ConfigResolutionStrategy;
import org.wildfly.swarm.spi.api.config.Builder;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.api.config.Resolver;
import org.wildfly.swarm.spi.api.config.SimpleKey;

@Vetoed
public class ConfigViewImpl
implements ConfigView {
    private Properties properties;
    private Map<String, List<ConfigNode>> registry = new HashMap<String, List<ConfigNode>>();
    private ConfigResolutionStrategy strategy = new ConfigResolutionStrategy();

    public ConfigViewImpl withProperties(Properties properties) {
        if (properties != null) {
            this.properties = properties;
            this.strategy.withProperties(properties);
        }
        return this;
    }

    public ConfigViewImpl withProperty(String name, String value) {
        this.strategy.withProperty(name, value);
        return this;
    }

    public ConfigViewImpl withEnvironment(Map<String, String> environment) {
        if (environment != null) {
            this.strategy.withEnvironment(environment);
        } else {
            this.strategy.withEnvironment(System.getenv());
        }
        return this;
    }

    public ConfigViewImpl withDefaults(ConfigNode defaultConfig) {
        this.strategy.defaults(defaultConfig);
        return this;
    }

    public synchronized void register(String name, ConfigNode config) {
        List<ConfigNode> nodes = this.registry.get(name);
        if (nodes == null) {
            nodes = new ArrayList<ConfigNode>();
            this.registry.put(name, nodes);
        }
        nodes.add(config);
    }

    public Set<String> registered() {
        return this.registry.keySet();
    }

    public Object valueOf(ConfigKey key) {
        return this.strategy.valueOf(key);
    }

    void withProfile(String ... names) {
        for (String name : names) {
            List<ConfigNode> nodes = this.registry.get(name);
            if (nodes == null) continue;
            nodes.forEach(node -> this.strategy.add((ConfigNode)node));
        }
    }

    void withProfile(List<String> names) {
        this.withProfile(names.toArray(new String[0]));
    }

    public void activate() {
        this.strategy.activate();
    }

    public Properties asProperties() {
        return this.strategy.asProperties();
    }

    public List<SimpleKey> simpleSubkeys(ConfigKey prefix) {
        return this.strategy.simpleSubkeysOf(prefix);
    }

    public boolean hasKeyOrSubkeys(ConfigKey subPrefix) {
        return this.strategy.hasKeyOrSubkeys(subPrefix);
    }

    public Resolver<String> resolve(ConfigKey key) {
        return new Builder((ConfigView)this, key).as(String.class);
    }

    public Stream<ConfigKey> allKeysRecursively() {
        return this.strategy.allKeysRecursively();
    }
}

