/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.SelfContainedContainer;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.container.internal.Deployer;
import org.wildfly.swarm.container.internal.Server;
import org.wildfly.swarm.container.runtime.ArtifactDeployer;
import org.wildfly.swarm.container.runtime.ConfigurableManager;
import org.wildfly.swarm.container.runtime.ImplicitDeployment;
import org.wildfly.swarm.container.runtime.RuntimeDeployer;
import org.wildfly.swarm.container.runtime.SocketBindingGroupConfigurer;
import org.wildfly.swarm.container.runtime.deployments.DefaultDeploymentCreator;
import org.wildfly.swarm.container.runtime.marshal.DMRMarshaller;
import org.wildfly.swarm.container.runtime.wildfly.ContentRepositoryServiceActivator;
import org.wildfly.swarm.container.runtime.wildfly.SwarmContentRepository;
import org.wildfly.swarm.container.runtime.wildfly.UUIDFactory;
import org.wildfly.swarm.container.runtime.xmlconfig.BootstrapConfiguration;
import org.wildfly.swarm.container.runtime.xmlconfig.BootstrapPersister;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.UserSpaceExtensionFactory;
import org.wildfly.swarm.spi.runtime.annotations.Post;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@ApplicationScoped
public class RuntimeServer
implements Server {
    @Inject
    @Pre
    private Instance<Customizer> preCustomizers;
    @Inject
    @Post
    private Instance<Customizer> postCustomizers;
    @Inject
    @Any
    private Instance<ServiceActivator> serviceActivators;
    @Inject
    @ImplicitDeployment
    private Instance<Archive> implicitDeployments;
    @Inject
    private DMRMarshaller dmrMarshaller;
    @Inject
    private DefaultDeploymentCreator defaultDeploymentCreator;
    @Inject
    private SwarmContentRepository contentRepository;
    @Inject
    private Instance<RuntimeDeployer> deployer;
    @Inject
    @Any
    private Instance<UserSpaceExtensionFactory> userSpaceExtensionFactories;
    @Inject
    private ConfigurableManager configurableManager;
    private SelfContainedContainer container;
    private boolean containerStarted;
    @Inject
    private ArtifactDeployer artifactDeployer;
    @Inject
    private SocketBindingGroupConfigurer socketBindingGroupConfigurer;
    private ModelControllerClient client;

    public RuntimeServer() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.containerStarted) {
                try {
                    SwarmMessages.MESSAGES.shutdownRequested();
                    this.stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }

    @Produces
    @ApplicationScoped
    ModelControllerClient client() {
        return this.client;
    }

    public Deployer start(boolean eagerOpen) throws Exception {
        File configurationFile;
        UUID uuid = UUIDFactory.getUUID();
        System.setProperty("jboss.server.management.uuid", uuid.toString());
        try {
            configurationFile = TempFileManager.INSTANCE.newTempFile("swarm-config-", ".xml");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<ModelNode> bootstrapOperations = new ArrayList<ModelNode>();
        final BootstrapConfiguration bootstrapConfiguration = () -> bootstrapOperations;
        this.container = new SelfContainedContainer(new Bootstrap.ConfigurationPersisterFactory(){

            public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                return new BootstrapPersister(bootstrapConfiguration, configurationFile);
            }
        });
        try (AutoCloseable handle = Performance.time((String)"pre-customizers");){
            for (Customizer each : this.preCustomizers) {
                SwarmMessages.MESSAGES.callingPreCustomizer(each);
                each.customize();
            }
        }
        handle = Performance.time((String)"post-customizers");
        var7_8 = null;
        try {
            for (Customizer each : this.postCustomizers) {
                SwarmMessages.MESSAGES.callingPostCustomizer(each);
                each.customize();
            }
        }
        catch (Throwable throwable) {
            var7_8 = throwable;
            throw throwable;
        }
        finally {
            if (handle != null) {
                if (var7_8 != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable) {
                        var7_8.addSuppressed(throwable);
                    }
                } else {
                    handle.close();
                }
            }
        }
        this.socketBindingGroupConfigurer.configure();
        handle = Performance.time((String)"configurable-manager rescan");
        var7_8 = null;
        try {
            this.configurableManager.rescan();
            this.configurableManager.log();
            this.configurableManager.close();
        }
        catch (Throwable throwable) {
            var7_8 = throwable;
            throw throwable;
        }
        finally {
            if (handle != null) {
                if (var7_8 != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable) {
                        var7_8.addSuppressed(throwable);
                    }
                } else {
                    handle.close();
                }
            }
        }
        handle = Performance.time((String)"marshall DMR");
        var7_8 = null;
        try {
            this.dmrMarshaller.marshal(bootstrapOperations);
        }
        catch (Throwable throwable) {
            var7_8 = throwable;
            throw throwable;
        }
        finally {
            if (handle != null) {
                if (var7_8 != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable) {
                        var7_8.addSuppressed(throwable);
                    }
                } else {
                    handle.close();
                }
            }
        }
        SwarmMessages.MESSAGES.wildflyBootstrap(((Object)bootstrapOperations).toString());
        Thread.currentThread().setContextClassLoader(RuntimeServer.class.getClassLoader());
        ArrayList<ContentRepositoryServiceActivator> activators = new ArrayList<ContentRepositoryServiceActivator>();
        this.serviceActivators.forEach(activators::add);
        activators.add(new ContentRepositoryServiceActivator(this.contentRepository));
        AutoCloseable wildflyStart = Performance.time((String)"WildFly start");
        Object object = null;
        try {
            Object serviceName2;
            ServiceContainer serviceContainer = null;
            try (AutoCloseable startWildflyItself = Performance.time((String)"Starting WildFly itself");){
                serviceContainer = this.container.start(bootstrapOperations, null, activators);
                this.containerStarted = true;
            }
            var11_23 = null;
            try (AutoCloseable checkFailedServices = Performance.time((String)"Checking for failed services");){
                for (Object serviceName2 : serviceContainer.getServiceNames()) {
                    ServiceController serviceController = serviceContainer.getService((ServiceName)serviceName2);
                    StartException exception = serviceController.getStartException();
                    if (exception == null) continue;
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                var11_23 = throwable;
                throw throwable;
            }
            ModelController controller = (ModelController)serviceContainer.getService(Services.JBOSS_SERVER_CONTROLLER).getValue();
            ExecutorService executor = Executors.newSingleThreadExecutor();
            AutoCloseable creatingControllerClient = Performance.time((String)"Creating controller client");
            serviceName2 = null;
            try {
                this.client = controller.createClient((Executor)executor);
            }
            catch (Throwable throwable) {
                serviceName2 = throwable;
                throw throwable;
            }
            finally {
                if (creatingControllerClient != null) {
                    if (serviceName2 != null) {
                        try {
                            creatingControllerClient.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serviceName2).addSuppressed(throwable);
                        }
                    } else {
                        creatingControllerClient.close();
                    }
                }
            }
            RuntimeDeployer deployer = (RuntimeDeployer)this.deployer.get();
            try (AutoCloseable installDeployer = Performance.time((String)"Installing deployer");){
                serviceContainer.addService(ServiceName.of((String[])new String[]{"swarm", "deployer"}), (Service)new ValueService((Value)new ImmediateValue((Object)deployer))).install();
            }
            var14_33 = null;
            try (AutoCloseable configUserSpaceExt = Performance.time((String)"Configure user-space extensions");){
                this.configureUserSpaceExtensions();
            }
            catch (Throwable throwable) {
                var14_33 = throwable;
                throw throwable;
            }
            var14_33 = null;
            try (AutoCloseable deployments = Performance.time((String)"Implicit Deployments");){
                for (Archive each : this.implicitDeployments) {
                    if (each == null) continue;
                    deployer.deploy(each);
                }
            }
            catch (Throwable throwable) {
                var14_33 = throwable;
                throw throwable;
            }
            this.artifactDeployer.deploy();
            deployer.implicitDeploymentsComplete();
            RuntimeDeployer runtimeDeployer = deployer;
            return runtimeDeployer;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (wildflyStart != null) {
                if (object != null) {
                    try {
                        wildflyStart.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    wildflyStart.close();
                }
            }
        }
    }

    private void configureUserSpaceExtensions() {
        this.userSpaceExtensionFactories.forEach(factory -> {
            try {
                factory.configure();
            }
            catch (Exception e) {
                SwarmMessages.MESSAGES.errorInstallingUserSpaceExtension(factory.getClass().getName());
            }
        });
    }

    @Override
    public void stop() throws Exception {
        this.container.stop();
        this.awaitContainerTermination();
        this.containerStarted = false;
        this.container = null;
        this.client = null;
        ((RuntimeDeployer)this.deployer.get()).removeAllContent();
        this.deployer = null;
    }

    private void awaitContainerTermination() {
        try {
            Field field = this.container.getClass().getDeclaredField("executor");
            field.setAccessible(true);
            ExecutorService executor = (ExecutorService)field.get(this.container);
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (IllegalAccessException | InterruptedException | NoSuchFieldException e) {
            SwarmMessages.MESSAGES.errorWaitingForContainerShutdown(e);
        }
    }

    @Override
    public Deployer deployer() {
        return (Deployer)this.deployer.get();
    }
}

